/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.context;

import com.kingdee.bos.qing.common.i18n.DefaultI18nContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.common.systemvar.SystemVarValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class QingContext
implements Serializable {
    private static ThreadLocal<QingContext> threadLocal = new ThreadLocal();
    private static final long serialVersionUID = -441660475514055622L;
    private String sessionID;
    private String accountId;
    private String tenantId;
    private II18nContext ii18nContext;
    private String userAgent;
    private Map<String, Object> customContext = new HashMap<String, Object>();
    private transient Map<SystemVarType, SystemVarValue> systemVars = new LinkedHashMap<SystemVarType, SystemVarValue>();

    public static void setCurrent(QingContext qingContext) {
        threadLocal.set(qingContext);
    }

    public static QingContext getCurrent() {
        return threadLocal.get();
    }

    public void addSystemVar(SystemVarType systemVarType, SystemVarValue systemVarValue) {
        if (null != systemVarValue) {
            this.systemVars.put(systemVarType, systemVarValue);
        }
    }

    public Set<SystemVarType> getSupportedSystemVarTypes() {
        return this.systemVars.keySet();
    }

    public String getUserId() {
        return String.valueOf(this.getSystemVar(SystemVarType.USER_ID));
    }

    public Object getSystemVar(SystemVarType varType) {
        SystemVarValue systemVarValue = this.systemVars.get((Object)varType);
        if (null != systemVarValue) {
            return systemVarValue.getValue(this);
        }
        return null;
    }

    public String getSystemVarStringValue(SystemVarType varType) {
        SystemVarValue systemVarValue = this.systemVars.get((Object)varType);
        if (null != systemVarValue) {
            return systemVarValue.getStringValue(this);
        }
        return null;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setIi18nContext(II18nContext ii18nContext) {
        this.ii18nContext = ii18nContext;
    }

    public II18nContext getIi18nContext() {
        if (this.ii18nContext == null) {
            this.ii18nContext = new DefaultI18nContext();
        }
        return this.ii18nContext;
    }

    public Object get(String key) {
        return this.customContext.get(key);
    }

    protected void set(String key, Object value) {
        this.customContext.put(key, value);
    }

    protected void remove(String key) {
        this.customContext.remove(key);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setUserId(String userId) {
        this.systemVars.put(SystemVarType.USER_ID, new SystemVarValue(userId));
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void restor() {
        IQingSession qingSession = QingSessionUtil.getQingSession(this.sessionID);
        qingSession.login(this.sessionID);
    }
}

