/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.resource;

import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.NetUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class QingServiceNodeMeta {
    private static final String QING_SERVICE_NODE_META_KEY_PREFIX = "qing.service.node.meta.";
    private Map<String, String> localNodeMetas = new HashMap<String, String>(5);
    private long lastMetaRefreshTime;
    private String localIp = NetUtil.getLocalHostIp();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getMetaData(String serviceIp) {
        if (this.localIp.equals(serviceIp)) {
            Map<String, String> map = this.localNodeMetas;
            synchronized (map) {
                HashMap<String, String> copyMap = new HashMap<String, String>(3);
                copyMap.putAll(this.localNodeMetas);
                return copyMap;
            }
        }
        String key = this.getMetaKey(serviceIp);
        String metaJson = QingSessionUtil.getGlobalQingSessionImpl().get(key);
        if (null == metaJson || metaJson.isEmpty()) {
            return new HashMap<String, String>(3);
        }
        return JsonUtil.decodeFromString(metaJson, Map.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMeta(Set<String> keys) {
        if (null == keys || keys.isEmpty()) {
            return;
        }
        Map<String, String> map = this.localNodeMetas;
        synchronized (map) {
            String metaKey = this.getMetaKey(this.localIp);
            for (String key : keys) {
                this.localNodeMetas.remove(key);
                String metaJson = JsonUtil.encodeToString(this.localNodeMetas);
                QingSessionUtil.getGlobalQingSessionImpl().set(metaKey, metaJson, 5, TimeUnit.MINUTES);
                this.lastMetaRefreshTime = System.currentTimeMillis();
            }
        }
    }

    private String getMetaKey(String ip) {
        return QING_SERVICE_NODE_META_KEY_PREFIX + ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMeta(Map<String, String> metas) {
        if (null == metas || metas.isEmpty()) {
            return;
        }
        Map<String, String> map = this.localNodeMetas;
        synchronized (map) {
            this.localNodeMetas.putAll(metas);
            String metaJson = JsonUtil.encodeToString(this.localNodeMetas);
            String metaKey = this.getMetaKey(this.localIp);
            QingSessionUtil.getGlobalQingSessionImpl().set(metaKey, metaJson, 5, TimeUnit.MINUTES);
            this.lastMetaRefreshTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshLocalMetas() {
        Map<String, String> map = this.localNodeMetas;
        synchronized (map) {
            long currentTime = System.currentTimeMillis();
            long duration = currentTime - this.lastMetaRefreshTime;
            if (duration >= 120000L) {
                String metaJson = JsonUtil.encodeToString(this.localNodeMetas);
                QingSessionUtil.getGlobalQingSessionImpl().set(this.getMetaKey(this.localIp), metaJson, 5, TimeUnit.MINUTES);
                this.lastMetaRefreshTime = currentTime;
            }
        }
    }

    public String getLocalIp() {
        return this.localIp;
    }
}

