/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.resource;

import com.kingdee.bos.qing.common.distribute.resource.CalcServerResource;
import com.kingdee.bos.qing.common.distribute.resource.ICalcServerResourceUpdateListener;
import com.kingdee.bos.qing.common.distribute.resource.IServerNodeChangedListener;
import com.kingdee.bos.qing.common.distribute.resource.ThreadResourceStatus;
import com.kingdee.bos.qing.common.distribute.session.UserSessionMgr;
import com.kingdee.bos.qing.common.distribute.task.DistributeTaskMgr;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.thread.GlobalScheduledExecutor;
import com.kingdee.bos.qing.common.thread.ThreadPoolMonitor;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.NetUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ServerResourceMgr
implements IServerNodeChangedListener {
    private static final String THREAD_RESOURCE_KEY_PREFIX = "Qing.CalcServer.ThreadPoolResource-";
    private static final ServerResourceMgr instance = new ServerResourceMgr();
    private static ThreadPoolManage.QingThreadPoolName[] THREAD_POOL_NAMES = new ThreadPoolManage.QingThreadPoolName[]{ThreadPoolManage.QingThreadPoolName.QING_LONG_TIME_TASK_HANDLER, ThreadPoolManage.QingThreadPoolName.QING_SHORT_TIME_TASK_HANDLER};
    private Map<String, CalcServerResource> serverResourceMap = new HashMap<String, CalcServerResource>(5);
    private String localIp;
    private Set<String> otherServerNodeIps = new HashSet<String>(5);
    private List<ICalcServerResourceUpdateListener> resourceChangeListeners = new LinkedList<ICalcServerResourceUpdateListener>();

    private ServerResourceMgr() {
        this.localIp = NetUtil.getLocalHostIp();
    }

    public static ServerResourceMgr getInstance() {
        return instance;
    }

    public void start() {
        GlobalScheduledExecutor.scheduleAtFixRate(new ServerThreadResourceUpdater(), 10000L, 3000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalcServerResource getOrCreateServerResource(String serverIp) {
        Map<String, CalcServerResource> map = this.serverResourceMap;
        synchronized (map) {
            CalcServerResource serverResource = this.serverResourceMap.get(serverIp);
            if (null == serverResource) {
                serverResource = new CalcServerResource(serverIp);
                this.serverResourceMap.put(serverIp, serverResource);
            }
            return serverResource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regResourceChangeListener(ICalcServerResourceUpdateListener changeListener) {
        List<ICalcServerResourceUpdateListener> list = this.resourceChangeListeners;
        synchronized (list) {
            this.resourceChangeListeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceChangeListener(ICalcServerResourceUpdateListener changeListener) {
        List<ICalcServerResourceUpdateListener> list = this.resourceChangeListeners;
        synchronized (list) {
            this.resourceChangeListeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBestResourceServer(ThreadPoolManage.QingThreadPoolName qingThreadPoolName) {
        HashSet<CalcServerResource> otherServerResourceSet = new HashSet<CalcServerResource>();
        Map<String, CalcServerResource> map = this.serverResourceMap;
        synchronized (map) {
            otherServerResourceSet.addAll(this.serverResourceMap.values());
        }
        String ip = null;
        ThreadResourceStatus pre = null;
        for (CalcServerResource calcServerResource : otherServerResourceSet) {
            ThreadResourceStatus current;
            String serverIp = calcServerResource.getServerIp();
            if (serverIp.equals(this.localIp) || null == (current = calcServerResource.getThreadResourceStatus(qingThreadPoolName.name()))) continue;
            if (null == pre) {
                if (current.getCurrentRunningSize() >= current.getMaxSize()) continue;
                pre = current;
                ip = calcServerResource.getServerIp();
                continue;
            }
            if (current.getCurrentRunningSize() >= pre.getCurrentRunningSize()) continue;
            ip = calcServerResource.getServerIp();
            pre = current;
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServerInitialise(Set<String> otherServerNodes) {
        Set<String> set = this.otherServerNodeIps;
        synchronized (set) {
            this.otherServerNodeIps.clear();
            this.otherServerNodeIps.addAll(otherServerNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServerAdd(String serverIp) {
        if (null == serverIp || serverIp.isEmpty()) {
            return;
        }
        Set<String> set = this.otherServerNodeIps;
        synchronized (set) {
            this.otherServerNodeIps.add(serverIp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServerRemove(String serverIp) {
        if (null == serverIp) {
            return;
        }
        Object object = this.otherServerNodeIps;
        synchronized (object) {
            this.otherServerNodeIps.remove(serverIp);
        }
        object = this.serverResourceMap;
        synchronized (object) {
            this.serverResourceMap.remove(serverIp);
        }
    }

    public void updateServerResource(String serverIp, String threadPoolName, int currentRunningSize) {
        CalcServerResource serverResource = this.getOrCreateServerResource(serverIp);
        ThreadPoolManage.QingThreadPoolName threadPool = ThreadPoolManage.QingThreadPoolName.valueOf(threadPoolName);
        ThreadResourceStatus threadResourceStatus = new ThreadResourceStatus();
        threadResourceStatus.setCurrentRunningSize(currentRunningSize);
        threadResourceStatus.setMaxSize(threadPool.getMaximumPoolSize());
        threadResourceStatus.setThreadPoolName(threadPoolName);
        serverResource.addThreadResourceStatus(threadResourceStatus);
    }

    private void updateOtherServerResource(Set<String> otherIps) {
        for (String ip : otherIps) {
            String key = THREAD_RESOURCE_KEY_PREFIX + ip;
            String value = QingSessionUtil.getGlobalQingSessionImpl().get(key);
            if (null == value) continue;
            CalcServerResource serverResource = this.getOrCreateServerResource(ip);
            List threadResources = JsonUtil.decodeFromString(value, List.class);
            for (Map mapData : threadResources) {
                serverResource.fromMap(mapData);
            }
            this.notifyResourceChanged(serverResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyResourceChanged(CalcServerResource serverResource) {
        if (!DistributeTaskMgr.getInstance().canDispatch()) {
            return;
        }
        try {
            ArrayList<ICalcServerResourceUpdateListener> copys = new ArrayList<ICalcServerResourceUpdateListener>();
            List<ICalcServerResourceUpdateListener> list = this.resourceChangeListeners;
            synchronized (list) {
                Iterator<ICalcServerResourceUpdateListener> it = this.resourceChangeListeners.iterator();
                while (it.hasNext()) {
                    ICalcServerResourceUpdateListener listener = it.next();
                    if (listener.isNeedRemove()) {
                        it.remove();
                    }
                    copys.add(listener);
                }
            }
            for (ICalcServerResourceUpdateListener listener : copys) {
                listener.onUpdate(serverResource);
            }
        }
        catch (Exception e) {
            LogUtil.error("resource listener handle error", e);
        }
    }

    private void uploadLocalThreadResources() {
        CalcServerResource localServerResource = this.getOrCreateServerResource(this.localIp);
        ArrayList<ThreadResourceStatus> threadResourceStatusList = new ArrayList<ThreadResourceStatus>(10);
        for (ThreadPoolManage.QingThreadPoolName threadPoolName : THREAD_POOL_NAMES) {
            ThreadPoolMonitor.ThreadPoolStatistic statistic = ThreadPoolMonitor.getInstance().getThreadPoolStatistic(threadPoolName);
            ThreadResourceStatus threadResourceStatus = new ThreadResourceStatus();
            threadResourceStatus.setThreadPoolName(threadPoolName.name());
            threadResourceStatus.setMaxSize(threadPoolName.getMaximumPoolSize());
            if (null != statistic) {
                threadResourceStatus.setCurrentRunningSize(statistic.getRunningSize());
            } else {
                threadResourceStatus.setCurrentRunningSize(0);
            }
            threadResourceStatus.setSessionBlockSize(UserSessionMgr.getInstance().getSessionBlockSize(threadPoolName.name()));
            threadResourceStatusList.add(threadResourceStatus);
            localServerResource.addThreadResourceStatus(threadResourceStatus);
        }
        String threadResourceKey = THREAD_RESOURCE_KEY_PREFIX + this.localIp;
        QingSessionUtil.getGlobalQingSessionImpl().set(threadResourceKey, JsonUtil.encodeToString(threadResourceStatusList));
    }

    private class ServerThreadResourceUpdater
    implements Runnable {
        private ServerThreadResourceUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet otherServerIps = new HashSet();
            Set set = ServerResourceMgr.this.otherServerNodeIps;
            synchronized (set) {
                otherServerIps.addAll(ServerResourceMgr.this.otherServerNodeIps);
            }
            ServerResourceMgr.this.uploadLocalThreadResources();
            ServerResourceMgr.this.updateOtherServerResource(otherServerIps);
        }
    }
}

