/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.task;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.distribute.task.DistributeTaskMgr;
import com.kingdee.bos.qing.common.distribute.task.IDistributeTaskProcessor;
import com.kingdee.bos.qing.common.distribute.task.TaskEvent;
import com.kingdee.bos.qing.common.distribute.task.TaskEventType;
import com.kingdee.bos.qing.common.distribute.task.TaskRequest;
import com.kingdee.bos.qing.common.distribute.task.TaskResponse;
import com.kingdee.bos.qing.common.framework.manage.ThreadTaskInvokeController;
import com.kingdee.bos.qing.util.LogUtil;

public class DistributeTaskProcessorImpl
implements IDistributeTaskProcessor {
    @Override
    public void processTaskEvent(TaskEvent taskEvent) {
        TaskEventType eventType = taskEvent.getEventType();
        switch (eventType) {
            case SUBMIT: {
                TaskRequest request = (TaskRequest)taskEvent.getData();
                request.setQingContext(QingContext.getCurrent());
                request.getTaskModel().addDispatchServer(request.getFromServer());
                try {
                    ThreadTaskInvokeController.getInstance().executeRemoteTaskAsync(taskEvent, request.getQingContext());
                }
                catch (Exception e) {
                    LogUtil.error("QingDistributeTask--consume remote task error from server:" + request.getFromServer() + ", currentServer=" + DistributeTaskMgr.getInstance().getLocalIp(), e);
                }
                break;
            }
            case RESPONSE: {
                TaskResponse response = (TaskResponse)taskEvent.getData();
                try {
                    DistributeTaskMgr.getInstance().handleTaskResponse(response.getRemoteServer(), taskEvent.getTaskId(), response);
                    break;
                }
                catch (Exception e) {
                    LogUtil.error("QingDistributeTask--handle response error from remoteServer: " + response.getRemoteServer() + ", currentServer=" + DistributeTaskMgr.getInstance().getLocalIp() + ",taskId=" + taskEvent.getTaskId(), e);
                }
            }
        }
    }
}

