/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.task;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.distribute.task.AbstractTaskChannel;
import com.kingdee.bos.qing.common.distribute.task.TaskEvent;
import com.kingdee.bos.qing.common.distribute.task.TaskRequest;
import com.kingdee.bos.qing.common.framework.manage.ClientCallManager;
import com.kingdee.bos.qing.common.framework.manage.ThreadTaskInvokeController;
import com.kingdee.bos.qing.common.framework.model.QingServiceAsynDispatcherModel;
import com.kingdee.bos.qing.common.framework.model.server.ServerRemoteCallMessage;
import com.kingdee.bos.qing.common.thread.DelayedRunnable;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;

public class TimeoutTaskReExecutor
implements DelayedRunnable {
    private TaskEvent taskEvent;
    private AbstractTaskChannel taskChannel;

    public TimeoutTaskReExecutor(TaskEvent taskEvent, AbstractTaskChannel taskChannel) {
        this.taskEvent = taskEvent;
        this.taskChannel = taskChannel;
    }

    @Override
    public void run() {
        TaskRequest request = (TaskRequest)this.taskEvent.getData();
        String taskId = this.taskEvent.getTaskId();
        if (this.taskChannel.tryAbandonTask(request.getQingContext().getSessionID(), taskId)) {
            QingServiceAsynDispatcherModel model = request.getTaskModel();
            LogUtil.info("QingDistributeTask--abandon remote task for timeout,taskId=" + taskId + ",service type = " + model.getServiceType() + ",method Name = " + model.getMethodName() + ",target server =" + this.taskChannel.getTargetIp());
            QingContext qingContext = request.getQingContext();
            try {
                qingContext.restor();
                ThreadTaskInvokeController.getInstance().submitReq(model, qingContext, false);
            }
            catch (Exception e) {
                ResponseErrorWrap responseErrorWrap = new ResponseErrorWrap(e);
                ServerRemoteCallMessage serverRemoteCallMessage = new ServerRemoteCallMessage(model.getClientID(), model.getCallID(), model.getOrderID(), responseErrorWrap);
                ClientCallManager.setCallResult(serverRemoteCallMessage);
                LogUtil.error("QingDistributeTask--reExecuteWaitingTask error", e);
            }
        }
    }

    @Override
    public long getDelayTime() {
        return SystemPropertyUtil.getInt("qing.distribute.task.timeout.value", 5000);
    }
}

