/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.zk;

import com.kingdee.bos.qing.common.distribute.resource.QingServerNodeObserver;
import com.kingdee.bos.qing.common.distribute.zk.ZKEnviroment;
import com.kingdee.bos.qing.common.distribute.zk.ZKProvider;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;

public class QingZKServerNodeObserver
extends QingServerNodeObserver {
    private static final String SERVER_ROOT_NODE_NAME = "calcServer";
    private ZKProvider zkProvider;
    private TreeCache serverNodeCache;
    private String serverRootNode;

    public QingZKServerNodeObserver(ZKProvider zkProvider) {
        this.zkProvider = zkProvider;
    }

    @Override
    public Set<String> getAllServerNodeIps() {
        Set<String> allServerNodeIps = this.readOtherServerIps();
        allServerNodeIps.add(this.getLocalIp());
        return allServerNodeIps;
    }

    @Override
    public void initialize() {
        CuratorFramework zkClient;
        block7: {
            block6: {
                zkClient = this.zkProvider.getClient();
                ZKEnviroment zkEnviroment = this.zkProvider.getEnviroment();
                String qingRootPath = zkEnviroment.getMutexLockPath();
                this.serverRootNode = qingRootPath + "/" + SERVER_ROOT_NODE_NAME;
                try {
                    ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(this.serverRootNode, null);
                }
                catch (Exception e) {
                    if (e instanceof KeeperException.NodeExistsException) break block6;
                    LogUtil.error("QingDistributeTask--create qing calc server base node error", e);
                    return;
                }
            }
            String myNode = this.serverRootNode + "/" + this.getLocalIp();
            try {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)zkClient.create().withMode(CreateMode.EPHEMERAL)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(myNode, null);
            }
            catch (Exception e) {
                if (e instanceof KeeperException.NodeExistsException) break block7;
                LogUtil.error("QingDistributeTask--create qing calc server ip node error", e);
                return;
            }
        }
        this.serverNodeCache = new TreeCache(zkClient, this.serverRootNode);
        this.serverNodeCache.getListenable().addListener((Object)new ServerNodeChangeListener());
        try {
            this.serverNodeCache.start();
        }
        catch (Exception e) {
            LogUtil.error("QingDistributeTask--start watch server base node error", e);
            return;
        }
    }

    private String getIpFromNodePath(ChildData data) {
        String nodePath = data.getPath();
        if (nodePath.endsWith(this.serverRootNode)) {
            return "";
        }
        int lastPathSeperatorIndex = nodePath.lastIndexOf("/");
        if (lastPathSeperatorIndex > -1 && lastPathSeperatorIndex < nodePath.length() - 1) {
            return nodePath.substring(lastPathSeperatorIndex + 1);
        }
        return "";
    }

    private Set<String> readOtherServerIps() {
        Map childDataMap = this.serverNodeCache.getCurrentChildren(this.serverRootNode);
        HashSet<String> serverIps = new HashSet<String>(5);
        if (null != childDataMap) {
            for (ChildData childData : childDataMap.values()) {
                String ip = this.getIpFromNodePath(childData);
                if (ip.isEmpty() || ip.equals(this.getLocalIp())) continue;
                serverIps.add(ip);
            }
        }
        return serverIps;
    }

    private class ServerNodeChangeListener
    implements TreeCacheListener {
        private ServerNodeChangeListener() {
        }

        public void childEvent(CuratorFramework curatorFramework, TreeCacheEvent treeCacheEvent) throws Exception {
            TreeCacheEvent.Type type = treeCacheEvent.getType();
            switch (type) {
                case NODE_REMOVED: {
                    String removedIp = QingZKServerNodeObserver.this.getIpFromNodePath(treeCacheEvent.getData());
                    LogUtil.info("QingDistributeTask--qing calc server removed,ip=" + removedIp);
                    QingZKServerNodeObserver.this.notifyServerRemove(removedIp);
                    break;
                }
                case NODE_ADDED: {
                    String newAddServerIp = QingZKServerNodeObserver.this.getIpFromNodePath(treeCacheEvent.getData());
                    LogUtil.info("QingDistributeTask--qing calc server added,ip=" + newAddServerIp);
                    QingZKServerNodeObserver.this.notifyServerAdd(newAddServerIp);
                    break;
                }
                case CONNECTION_LOST: {
                    LogUtil.info("QingDistributeTask-- qing zk client connection lost");
                    QingZKServerNodeObserver.this.isUsable.set(false);
                    break;
                }
                case CONNECTION_RECONNECTED: {
                    LogUtil.info("QingDistributeTask-- qing zk client reconnect succeed");
                    QingZKServerNodeObserver.this.isUsable.set(true);
                    break;
                }
                case INITIALIZED: {
                    QingZKServerNodeObserver.this.isUsable.set(true);
                    QingZKServerNodeObserver.this.notifyInitialise(QingZKServerNodeObserver.this.readOtherServerIps());
                }
            }
        }
    }
}

