/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.zk;

import com.kingdee.bos.qing.common.distribute.zk.ZKPwdDecoder;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.RetryForever;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class ZKClientHelper {
    private static CuratorFramework cfClient;
    private static ZKPwdDecoder pwdDecoder;
    private static final String USER = "user";
    private static final String SCHEME = "scheme";
    private static final String PASSWORD = "password";
    private static boolean needRebuildClient;

    public static void setPwdDecoder(ZKPwdDecoder pwdDecoder) {
        ZKClientHelper.pwdDecoder = pwdDecoder;
    }

    public static synchronized void markClientRebuildFlag() {
        needRebuildClient = true;
    }

    public static synchronized CuratorFramework getCuratorFramework(String zkAddress) {
        if (null == cfClient) {
            cfClient = ZKClientHelper.createCfAndInitialise(zkAddress);
        } else if (needRebuildClient) {
            cfClient.close();
            cfClient = ZKClientHelper.createCfAndInitialise(zkAddress);
            needRebuildClient = false;
        }
        if (!cfClient.getZookeeperClient().isConnected()) {
            try {
                cfClient.blockUntilConnected(SystemPropertyUtil.getInt("qing_lock_zk_connect_timeout", 60), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LogUtil.error("connecting to zk server error", e);
            }
        }
        return cfClient;
    }

    private static CuratorFramework createCfAndInitialise(String zkAddress) {
        cfClient = ZKClientHelper.newCfInstance(zkAddress);
        cfClient.start();
        return cfClient;
    }

    private static CuratorFramework newCfInstance(String url) {
        Map<String, String> urlInfo = ZKClientHelper.parseUrl(url);
        String address = urlInfo.get("zkaddreass");
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(address).sessionTimeoutMs(Integer.getInteger("curator-default-session-timeout", 60000).intValue()).connectionTimeoutMs(Integer.getInteger("curator-default-connection-timeout", 15000).intValue()).retryPolicy((RetryPolicy)new RetryForever(3000));
        String user = urlInfo.get(USER);
        String pass = urlInfo.get(PASSWORD);
        if (user != null && pass != null) {
            final String auth = user + ":" + pass;
            ACLProvider aclProvider = new ACLProvider(){
                private List<ACL> acl;

                public List<ACL> getDefaultAcl() {
                    if (this.acl == null) {
                        ArrayList acl = ZooDefs.Ids.CREATOR_ALL_ACL;
                        acl.clear();
                        acl.add(new ACL(31, new Id("auth", auth)));
                        this.acl = acl;
                    }
                    return this.acl;
                }

                public List<ACL> getAclForPath(String path) {
                    return this.acl;
                }
            };
            try {
                builder.authorization(urlInfo.get(SCHEME), auth.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.error(e.getMessage(), e);
            }
            builder.aclProvider(aclProvider);
        }
        return builder.build();
    }

    private static Map<String, String> parseUrl(String url) {
        ConcurrentHashMap<String, String> m = new ConcurrentHashMap<String, String>();
        int propIndex = url.indexOf("?");
        String _url = url;
        if (propIndex > 0) {
            String[] sl = url.split("\\?");
            _url = sl[0];
            String strUrlParams = sl[1];
            Properties prop = new Properties();
            try {
                String[] params = null;
                params = strUrlParams.contains("&") ? strUrlParams.split("&") : new String[]{strUrlParams};
                String[] var8 = params;
                int var9 = params.length;
                for (int var10 = 0; var10 < var9; ++var10) {
                    String p = var8[var10];
                    int firstIndex = p.indexOf("=");
                    if (firstIndex <= -1) continue;
                    String key = p.substring(0, firstIndex);
                    String value = p.substring(firstIndex + 1);
                    prop.put(key, value);
                }
                m.put(SCHEME, prop.getProperty(SCHEME, "digest"));
                m.put(USER, prop.getProperty(USER));
                String pass = prop.getProperty(PASSWORD);
                if (pass != null && null != pwdDecoder) {
                    pass = pwdDecoder.decodePwd(pass);
                }
                m.put(PASSWORD, pass);
            }
            catch (Exception e) {
                LogUtil.error("decode zk url failed", e);
            }
        }
        m.put("zkaddreass", ZKClientHelper._getZkAddress(_url));
        m.put("zkrootpath", ZKClientHelper._getZkRootPath(_url));
        return m;
    }

    private static String _getZkAddress(String url) {
        int index = url.indexOf("/");
        return index > 0 ? url.substring(0, index) : url;
    }

    private static String _getZkRootPath(String url) {
        int index = url.indexOf("/");
        if (index > 0) {
            String r = url.substring(index);
            if (!r.endsWith("/")) {
                r = r + "/";
            }
            return r;
        }
        return "/";
    }

    static {
        needRebuildClient = false;
    }
}

