/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.zk.lock;

import com.kingdee.bos.qing.common.distribute.zk.ZKClient;
import com.kingdee.bos.qing.common.distribute.zk.ZKProvider;
import com.kingdee.bos.qing.common.distribute.zk.lock.ZkInternalMutex;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import java.util.concurrent.TimeUnit;

class QingZkMutex {
    private ZKClient zkClient;
    private ZkInternalMutex mutex;
    private String lockPath;

    public QingZkMutex(ZKProvider zkProvider, String lockKey) throws QingLockRequireException {
        this.zkClient = new ZKClient(zkProvider);
        this.lockPath = this.getLockPath(lockKey);
        this.mutex = new ZkInternalMutex(this.zkClient.getClient(), this.lockPath);
    }

    public void aquire() throws AbstractQingException {
        this.mutex.acquire();
    }

    public boolean aquire(long timeoutMs) throws AbstractQingException {
        return this.mutex.acquire(timeoutMs, TimeUnit.MILLISECONDS);
    }

    private String getLockPath(String lockKey) throws QingLockRequireException {
        if (lockKey == null) {
            throw new QingLockRequireException("lock key can not be null", 5001001);
        }
        try {
            String basePath = this.zkClient.createBasePath();
            String lockPath = basePath + "/" + lockKey;
            return lockPath;
        }
        catch (Exception e) {
            throw new QingLockRequireException("create base path failed", e);
        }
    }

    public void release() throws AbstractQingException {
        if (null != this.mutex) {
            this.mutex.release();
            this.zkClient.delete(this.lockPath, -1);
        }
    }
}

