/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.distribute.zk.lock;

import com.kingdee.bos.qing.common.distribute.zk.ZKClientHelper;
import com.kingdee.bos.qing.common.distribute.zk.ZKProvider;
import com.kingdee.bos.qing.common.distribute.zk.lock.QingZkMutex;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.lock.ZkClientSendTreadDeadException;
import com.kingdee.bos.qing.util.LogUtil;

public class ZKLockImpl
implements ILock {
    private QingZkMutex mutex;
    private String lockKey;
    private ZKProvider zkProvider;
    private volatile boolean lockSucceed = false;

    public ZKLockImpl(String lockKey, ZKProvider zkProvider) {
        this.lockKey = lockKey;
        this.zkProvider = zkProvider;
    }

    @Override
    public void lock() throws QingLockRequireException {
        this.lockSucceed = false;
        if (null == this.mutex) {
            this.mutex = new QingZkMutex(this.zkProvider, this.lockKey);
        }
        try {
            this.mutex.aquire();
            this.lockSucceed = true;
        }
        catch (ZkClientSendTreadDeadException e) {
            LogUtil.warn("client cnxn send thread dead,reCreate a new Client");
            ZKClientHelper.markClientRebuildFlag();
            this.reAquireMutex();
        }
        catch (Exception e) {
            throw new QingLockRequireException("lock failed", e);
        }
    }

    private void reAquireMutex() throws QingLockRequireException {
        this.mutex = new QingZkMutex(this.zkProvider, this.lockKey);
        try {
            this.mutex.aquire();
            this.lockSucceed = true;
        }
        catch (AbstractQingException ex) {
            throw new QingLockRequireException("lock failed", ex);
        }
    }

    @Override
    public boolean tryLock() throws QingLockRequireException {
        return this.tryLock(1L);
    }

    @Override
    public boolean tryLock(long timeout) throws QingLockRequireException {
        this.lockSucceed = false;
        if (null == this.mutex) {
            this.mutex = new QingZkMutex(this.zkProvider, this.lockKey);
        }
        try {
            this.lockSucceed = this.mutex.aquire(timeout);
            return this.lockSucceed;
        }
        catch (ZkClientSendTreadDeadException e) {
            LogUtil.warn("client cnxn send thread dead,reCreate a new Client");
            ZKClientHelper.markClientRebuildFlag();
            return this.tryReAquireMutex(timeout);
        }
        catch (Exception e) {
            throw new QingLockRequireException("lock failed", e);
        }
    }

    private boolean tryReAquireMutex(long timeout) throws QingLockRequireException {
        this.mutex = new QingZkMutex(this.zkProvider, this.lockKey);
        try {
            this.lockSucceed = this.mutex.aquire(timeout);
            return this.lockSucceed;
        }
        catch (Exception e) {
            throw new QingLockRequireException("lock failed", e);
        }
    }

    @Override
    public void unlock() {
        block3: {
            try {
                if (null != this.mutex && this.lockSucceed) {
                    this.mutex.release();
                }
            }
            catch (Exception e) {
                if (!LogUtil.isDebugEnabled()) break block3;
                LogUtil.debug("unlock error,lockKey :" + this.lockKey + ", desc:" + e.getMessage());
            }
        }
    }
}

