/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.model.client;

import com.kingdee.bos.qing.common.framework.model.AbstractMessage;
import com.kingdee.bos.qing.common.framework.model.client.ClientClosedMessage;
import com.kingdee.bos.qing.common.framework.model.client.ClientPingMessage;
import com.kingdee.bos.qing.common.framework.model.client.ClientPollingMessage;
import com.kingdee.bos.qing.common.framework.model.client.ClientRemoteCallCancelMessage;
import com.kingdee.bos.qing.common.framework.model.client.ClientRemoteCallMessage;
import com.kingdee.bos.qing.common.framework.model.client.ServerChannelAckMessage;
import com.kingdee.bos.qing.common.framework.model.client.ServerRemoteCallAckMessage;
import com.kingdee.bos.qing.common.framework.model.server.AbstractServerMessage;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.ZipUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractClientMessage
extends AbstractMessage {
    private static JsonUtil.CustomJsonParser customJsonParser = new JsonUtil.CustomJsonParser();
    private static Map<String, Class<? extends AbstractClientMessage>> clientMessageClassMap = new HashMap<String, Class<? extends AbstractClientMessage>>();

    @Override
    public boolean isClientMessage() {
        return true;
    }

    public boolean isSupportWebsocket() {
        return true;
    }

    public static AbstractClientMessage edcode(String message) {
        try {
            String jsonString = ZipUtil.unGzipToStr(StringUtils.decodeBase64ToByteArray(message));
            if (jsonString.startsWith("%")) {
                jsonString = URLDecoder.decode(jsonString, "utf-8");
            }
            return JsonUtil.decodeFromString(customJsonParser, jsonString, AbstractClientMessage.class);
        }
        catch (IOException e) {
            LogUtil.error(e.getMessage(), e);
            return null;
        }
    }

    public List<AbstractServerMessage> createAcks() {
        return Collections.emptyList();
    }

    public void collectAliveClientIDs(Set<String> clientIDs) {
    }

    static {
        customJsonParser.addCustomDecoder(AbstractClientMessage.class, new ClientMessageJsonDecoder());
        clientMessageClassMap.put("ClientClosed", ClientClosedMessage.class);
        clientMessageClassMap.put("ClientPing", ClientPingMessage.class);
        clientMessageClassMap.put("ClientRemoteCall", ClientRemoteCallMessage.class);
        clientMessageClassMap.put("ClientRemoteCallCancel", ClientRemoteCallCancelMessage.class);
        clientMessageClassMap.put("ServerRemoteCallAck", ServerRemoteCallAckMessage.class);
        clientMessageClassMap.put("ServerChannelAck", ServerChannelAckMessage.class);
        clientMessageClassMap.put("ClientPolling", ClientPollingMessage.class);
    }

    private static class ClientMessageJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractClientMessage> {
        private ClientMessageJsonDecoder() {
        }

        @Override
        protected AbstractClientMessage decode(JsonUtil.AbstractJsonDecoder.Json json) {
            String messageType = json.getAttrValue("messageType");
            Class clientMessageClass = (Class)clientMessageClassMap.get(messageType);
            if (clientMessageClass != null) {
                return (AbstractClientMessage)this.fromJson(json, clientMessageClass);
            }
            return null;
        }
    }
}

