/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.server.dependency;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.manage.ClientManager;
import com.kingdee.bos.qing.common.framework.server.annotation.ServiceAnnotationUtil;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class QingServiceFactory {
    private static Map<String, Class<?>> serviceClassMap = new HashMap();

    QingServiceFactory() {
    }

    public static void regist(String serviceType, Class<?> serviceClass) {
        if (serviceClassMap.containsKey(serviceType)) {
            throw new RuntimeException("something is wrong");
        }
        ServiceAnnotationUtil.handlerClassAnnotation(serviceClass);
        serviceClassMap.put(serviceType, serviceClass);
    }

    public static final Object getServiceImpl(String serviceType) throws InstantiationException, IllegalAccessException {
        Class<?> clazz;
        if (serviceType == null) {
            return null;
        }
        int lastIndexOf = serviceType.lastIndexOf(47);
        if (lastIndexOf > 0) {
            String oldwUrl = serviceType.substring(0, lastIndexOf);
            String newUrl = serviceType.substring(lastIndexOf);
            lastIndexOf = oldwUrl.lastIndexOf(47);
            serviceType = newUrl = oldwUrl.substring(lastIndexOf) + newUrl;
        }
        if ((clazz = serviceClassMap.get(serviceType)) == null) {
            return null;
        }
        return clazz.newInstance();
    }

    static {
        QingServiceFactory.regist("QingSystemFramework", QingSystemFrameworkService.class);
    }

    public static class QingSystemFrameworkService
    implements IQingContextable {
        private QingContext qingContext;

        @Override
        public void setQingContext(QingContext qingContext) {
            this.qingContext = qingContext;
        }

        public byte[] closePage(Map<String, String> params) {
            String clientID = params.get("clientID");
            ArrayList<String> clientIDs = new ArrayList<String>();
            clientIDs.add(clientID);
            ClientManager.setClientClosed(this.qingContext, clientIDs);
            return ResponseUtil.output(new ResponseSuccessWrap(true));
        }
    }
}

