/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.server.task;

import com.kingdee.bos.qing.common.framework.manage.ClientCallManager;
import com.kingdee.bos.qing.common.framework.manage.ClientManager;
import com.kingdee.bos.qing.common.framework.server.task.AsynServerRequestInvokeTask;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServerRequestInvokeContext {
    private static ThreadLocal<ServerRequestInvokeContext> threadLocal = new ThreadLocal();
    private static ThreadLocal<AsynServerRequestInvokeTask> asynServerRequestTL = new ThreadLocal();
    private CheckerName checkerName;
    private String appID;
    private String clientID;
    private String callID;
    private long orderID;
    private volatile boolean removeFromHealthCheck;
    private volatile boolean isClientClose = false;
    private volatile boolean isCallCancel = false;
    private volatile boolean isInterrupt = false;
    private volatile Set<String> relativeClientIDs = new HashSet<String>();
    private boolean needCalcCosts = true;
    private boolean isReqMigrated = false;

    public ServerRequestInvokeContext(CheckerName checkerName, String appID, String clientID, String callID, long orderID) {
        this.checkerName = checkerName;
        this.appID = appID;
        this.clientID = clientID;
        this.callID = callID;
        this.orderID = orderID;
    }

    public boolean isNeedCalcCosts() {
        return this.needCalcCosts;
    }

    public void setNeedCalcCosts(boolean needCalcCosts) {
        this.needCalcCosts = needCalcCosts;
    }

    public void stopHealthCheck() {
        this.removeFromHealthCheck = true;
    }

    public boolean isReqMigrated() {
        return this.isReqMigrated;
    }

    public void setReqMigrated(boolean reqMigrated) {
        this.isReqMigrated = reqMigrated;
    }

    public boolean isStopHealthCheck() {
        return this.removeFromHealthCheck;
    }

    public String getAppID() {
        return this.appID;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getCallID() {
        return this.callID;
    }

    public long getOrderID() {
        return this.orderID;
    }

    public boolean isClientClosedOrCallCancel(Map<String, Boolean> clientsClosed, Map<String, Boolean> callsCanceled) {
        if (ClientManager.isClientClosed(this.clientID, false, clientsClosed)) {
            this.isClientClose = true;
            clientsClosed.put(this.clientID, true);
            return true;
        }
        if (ClientCallManager.isCallCanceled(this.clientID, this.callID, callsCanceled)) {
            this.isCallCancel = true;
            return true;
        }
        return false;
    }

    public void setCallWorkingInServer() {
        ClientCallManager.setCallWorkingInServer(this.checkerName, this.clientID, this.callID);
    }

    public void clearCallWorkingStatus() {
        LogUtil.info("clearCallWorkingStatus,clientId=" + this.clientID + ",callId=" + this.callID);
        ClientCallManager.clearCallWorkingStatus(this.checkerName, this.clientID, this.callID);
    }

    public boolean isCallStopWorkingStatus() {
        return ClientCallManager.isCallStopWorkingStatus(this.checkerName, this.clientID, this.callID);
    }

    public void clearCallStopWoringStatus() {
        LogUtil.info("clearCallStopWoringStatus,clientId=" + this.clientID + ",callId=" + this.callID);
        ClientCallManager.clearCallStopWorkingStatus(this.checkerName, this.clientID, this.callID);
    }

    public boolean isInterrupt() {
        return this.isCallCancel || this.isClientClose || this.isInterrupt || this.removeFromHealthCheck;
    }

    public Set<String> getRelativeClientIDs() {
        return this.relativeClientIDs;
    }

    public void refreshRelativeClients() {
        Set<String> relativeClientIDs;
        if (!this.relativeClientIDs.isEmpty() && (relativeClientIDs = ClientCallManager.getRelativeClientIDs(this.clientID)) != null) {
            this.relativeClientIDs.addAll(relativeClientIDs);
        }
    }

    public static void setThreadLocal(ServerRequestInvokeContext invokeContext) {
        threadLocal.set(invokeContext);
    }

    public static void removeThreadLocal() {
        threadLocal.remove();
    }

    public static ServerRequestInvokeContext get() {
        return threadLocal.get();
    }

    public static AsynServerRequestInvokeTask getAsynServerRequestTL() {
        return asynServerRequestTL.get();
    }

    public static void setAsynServerRequestTL(AsynServerRequestInvokeTask asynServerRequest) {
        asynServerRequestTL.set(asynServerRequest);
    }

    public static void staticCheckInterrupt(ServerRequestInvokeContext invokeContext) throws InterruptedException {
        if (invokeContext != null) {
            invokeContext.isInterrupted();
        }
    }

    public void setInterrupt(boolean interrupt) {
        this.isInterrupt = interrupt;
    }

    public boolean isInterrupted() throws InterruptedException {
        if (this.isCallCancel) {
            throw new InterruptedException("user cancel call:" + this.callID);
        }
        if (this.isClientClose) {
            throw new InterruptedException("user close client:" + this.clientID);
        }
        if (this.isInterrupt) {
            throw new InterruptedException("program cancel call:" + this.clientID);
        }
        return false;
    }

    public static String staticGetClientID() {
        ServerRequestInvokeContext invokeContext = threadLocal.get();
        if (invokeContext != null) {
            return invokeContext.clientID;
        }
        return null;
    }

    public static String staticGetCallID() {
        ServerRequestInvokeContext invokeContext = threadLocal.get();
        if (invokeContext != null) {
            return invokeContext.callID;
        }
        return null;
    }

    public static enum CheckerName {
        Web,
        RPCServer;

    }
}

