/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.web;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.framework.web.dependency.QingWebRequestDispatcher;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServerFileAccesser {
    private static final String FILE_NAME = "fileName";
    private static final Pattern QING_FILENAME_PATTERN = Pattern.compile("^[0-9a-zA-Z_\\-]{1,}$");

    public static void loadFile(QingContext qingContext, String appID, String fileName, AbstractQingFileType fileType, OutputStream outputStream) throws IOException {
        Matcher qingFileNameMatcher = QING_FILENAME_PATTERN.matcher(fileName);
        if (!qingFileNameMatcher.matches()) {
            throw new IOException("incorrect fileName!");
        }
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put(FILE_NAME, fileName);
        parameterMap.put("typeIndex", fileType.getTypeIndex() + "");
        ServerFileAccesser.synDispatcherRead(qingContext, appID, "/qing/resource.do", "getFileData", outputStream, parameterMap);
    }

    public static void loadImgByFullPath(QingContext qingContext, String appID, String fullPath, OutputStream outputStream) throws IOException {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("fullPath", fullPath);
        ServerFileAccesser.synDispatcherRead(qingContext, appID, "/qing/imagelib.do", "getImageFileNameByFullPath", outputStream, parameterMap);
    }

    public static void synDispatcherRead(QingContext qingContext, String appID, String serviceType, String methodName, OutputStream outputStream, Map<String, String> parameterMap) throws IOException {
        long offset = 0L;
        while (true) {
            byte[] result;
            parameterMap.put("offset", Long.toString(offset));
            try {
                result = (byte[])QingWebRequestDispatcher.synDispatcher(qingContext, appID, serviceType, methodName, parameterMap);
            }
            catch (AbstractQingException e) {
                throw new IOException(e);
            }
            if (result == null || result[0] == 1) break;
            offset += (long)(result.length - 1);
            outputStream.write(result, 1, result.length - 1);
            outputStream.flush();
        }
    }

    public static final byte[] uploadPiece(QingContext qingContext, String appID, String fileNameKey, byte[] buffer, int index) throws AbstractQingException {
        return (byte[])QingWebRequestDispatcher.synDispatcher(qingContext, appID, "/qing/resource.do", "uploadPiece", fileNameKey, buffer, index);
    }

    public static final byte[] readPartialFile(QingContext qingContext, String appID, Map<String, String> params) throws AbstractQingException {
        return (byte[])QingWebRequestDispatcher.synDispatcher(qingContext, appID, "/qing/fontLib.do", "readPartialFile", params);
    }

    public static final byte[] combineUpload(QingContext qingContext, String appID, String fileNameKey, int index) throws AbstractQingException {
        return (byte[])QingWebRequestDispatcher.synDispatcher(qingContext, appID, "/qing/resource.do", "combineUpload", fileNameKey, index);
    }

    public static final void deleteFile(QingContext qingContext, String appID, String fileNameKey, int typeIndex) throws AbstractQingException {
        QingWebRequestDispatcher.synDispatcher(qingContext, appID, "/qing/resource.do", "deleteFile", fileNameKey, typeIndex);
    }

    public static final void delayedDeleteFile(QingContext qingContext, String appID, String fileNameKey, int typeIndex, long delayMillis) throws AbstractQingException {
        QingWebRequestDispatcher.synDispatcher(qingContext, appID, "/qing/resource.do", "delayedDeleteFile", fileNameKey, typeIndex, delayMillis);
    }

    public static final byte[] readFontFile(QingContext qingContext, String appID, Map<String, String> params) throws AbstractQingException {
        return (byte[])QingWebRequestDispatcher.synDispatcher(qingContext, appID, "/qing/fontLib.do", "read", params);
    }
}

