/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.expr;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractExpr;

public class StringExpr
extends AbstractExpr {
    private String _content;

    public StringExpr(String content, boolean isContainMarks) {
        this._content = isContainMarks ? content.substring(1, content.length() - 1) : content;
    }

    @Override
    public int getPriority() {
        return 99;
    }

    @Override
    public String encode() {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(this._content);
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public int getReturnDataType() {
        return 1;
    }

    @Override
    public Object execute(IExecuteContext ctx) throws ExecuteException {
        return this._content;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringExpr) {
            StringExpr another = (StringExpr)obj;
            return this._content.equals(another._content);
        }
        return false;
    }
}

