/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.i18n;

import com.kingdee.bos.qing.common.i18n.factory.LanguageFactory;
import com.kingdee.bos.qing.common.i18n.langmessage.ILangMessage;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class LanguageManager
implements Serializable {
    private static final long serialVersionUID = 3747317536445718699L;
    public static final Set<Locale> SUPPORTED = new HashSet<Locale>();
    private static final String RESOURCES_PATH = "resources/qing-common";
    private static final Map<Locale, Locale> COMPATIBLE;
    private Locale locale;

    public LanguageManager() {
        this.setLocale(Locale.getDefault());
    }

    public void setLocale(Locale locale) {
        if (!SUPPORTED.contains(locale)) {
            locale = LanguageManager.demoteForBundle(locale);
        }
        this.locale = locale;
    }

    public static Locale demoteForBundle(Locale locale) {
        Locale demotion = new Locale(locale.getLanguage(), locale.getCountry());
        if (SUPPORTED.contains(demotion)) {
            return demotion;
        }
        if (COMPATIBLE.containsKey(demotion)) {
            return COMPATIBLE.get(demotion);
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(RESOURCES_PATH, locale);
            locale = bundle.getLocale();
        }
        catch (MissingResourceException e) {
            LogUtil.warn("\u672a\u627e\u5230\u8bed\u8a00\u6807\u8bc6\uff1a" + locale);
            locale = Locale.SIMPLIFIED_CHINESE;
        }
        return locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLangMessage(String key, String resPath, String tempInfo) {
        block8: {
            ILangMessage langMessage = LanguageFactory.getLangMessage();
            if (langMessage != null) {
                String message = null;
                try {
                    message = langMessage.getLangMessage(key, resPath);
                }
                catch (Exception e) {
                    LogUtil.error("LanguageMessage impl error", e);
                }
                if (StringUtils.isNotEmpty(message)) {
                    return message;
                }
            }
            try {
                String keyInfo;
                ResourceBundle bundle = ResourceBundle.getBundle(resPath, this.locale);
                if (bundle != null && (keyInfo = bundle.getString(key)) != null) {
                    return keyInfo;
                }
            }
            catch (Exception e) {
                if (!LogUtil.isDebugEnabled()) break block8;
                LogUtil.debug(e.getMessage());
            }
        }
        if (tempInfo != null) {
            return tempInfo;
        }
        throw new MissingResourceException("Do not find any mapping Language Info or Do not specified one temporary text.", null, key);
    }

    static {
        SUPPORTED.add(Locale.SIMPLIFIED_CHINESE);
        SUPPORTED.add(Locale.TRADITIONAL_CHINESE);
        SUPPORTED.add(Locale.ENGLISH);
        COMPATIBLE = new HashMap<Locale, Locale>();
        COMPATIBLE.put(new Locale("zh", "HK"), Locale.TRADITIONAL_CHINESE);
    }
}

