/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.jsengine;

import com.kingdee.bos.qing.common.jsengine.IJsRtEnv;
import com.kingdee.bos.qing.common.jsengine.exception.JavaScriptException;
import com.kingdee.bos.qing.common.jsengine.mock.Console;
import com.kingdee.bos.qing.common.jsengine.mock.Image;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;

class JdkJsEnv
implements IJsRtEnv {
    protected boolean scriptsThreadsafe;
    protected Map<String, Object> prePutObjects;
    protected String[] preloadedScripts;
    protected Invocable invokeEngine;

    public JdkJsEnv(Map<String, Object> prePutObjects, String ... preLoadJsFile) throws JavaScriptException {
        this(true, prePutObjects, preLoadJsFile);
    }

    public JdkJsEnv(boolean scriptsThreadsafe, Map<String, Object> prePutObjects, String ... preloadedScripts) throws JavaScriptException {
        this.scriptsThreadsafe = scriptsThreadsafe;
        this.prePutObjects = prePutObjects;
        this.preloadedScripts = preloadedScripts;
        if (scriptsThreadsafe) {
            this.invokeEngine = this.createEngine(prePutObjects, preloadedScripts);
        }
    }

    @Override
    public Object executeFunction(String functionName, Object ... functionParams) {
        try {
            if (!this.scriptsThreadsafe) {
                this.invokeEngine = this.createEngine(this.prePutObjects, this.preloadedScripts);
            }
            return this.invokeEngine.invokeFunction(functionName, functionParams);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected Invocable createEngine(Map<String, Object> prePutObjects, String ... preloadedScripts) throws JavaScriptException {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        SimpleBindings rootBindings = new SimpleBindings();
        rootBindings.put("console", (Object)new Console());
        if (prePutObjects != null) {
            for (Map.Entry<String, Object> entry : prePutObjects.entrySet()) {
                rootBindings.put(entry.getKey(), entry.getValue());
            }
        }
        engine.setBindings(rootBindings, 100);
        this.importJavaClass(engine);
        this.loadJsFile(engine, preloadedScripts);
        if (engine instanceof Invocable) {
            return (Invocable)((Object)engine);
        }
        throw new RuntimeException("This js engine is not Invocable!");
    }

    protected void loadJsFile(ScriptEngine engine, String ... preloadedScripts) throws JavaScriptException {
        block6: {
            if (preloadedScripts == null) break block6;
            for (String preloadScript : preloadedScripts) {
                URL resource = this.getClass().getResource(preloadScript);
                if (resource == null) {
                    throw new JavaScriptException("Cannot load resources " + preloadScript + ", get resource return null!");
                }
                InputStream inputStream = null;
                InputStreamReader in = null;
                try {
                    inputStream = this.getClass().getResourceAsStream(preloadScript);
                    in = new InputStreamReader(inputStream, "utf8");
                    engine.eval(in);
                }
                catch (Exception e) {
                    try {
                        throw new JavaScriptException((Throwable)e, "Load resources " + preloadScript + " failed!");
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close(inputStream);
                        CloseUtil.close(in);
                        throw throwable;
                    }
                }
                CloseUtil.close(inputStream);
                CloseUtil.close(in);
            }
        }
    }

    private void importJavaClass(ScriptEngine engine) {
        try {
            String fullClassName = Image.class.getName();
            String js = "var Image = Java.type('" + fullClassName + "');";
            engine.eval(js);
        }
        catch (Exception e) {
            LogUtil.error("load Image Object Error", e);
        }
    }
}

