/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.jsengine.mock;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;

class FontUtil {
    FontUtil() {
    }

    public static Font parseCssFont(String fontCss) {
        String fontFamily = "";
        String fontSize = null;
        float italic = TextAttribute.POSTURE_REGULAR.floatValue();
        Float weight = TextAttribute.WEIGHT_REGULAR;
        String[] elements = fontCss.split("\\s+");
        for (int i = 0; i < elements.length; ++i) {
            String element = elements[i];
            if (element.equals("normal")) continue;
            if (element.equalsIgnoreCase("italic") || element.equalsIgnoreCase("oblique")) {
                italic = TextAttribute.POSTURE_OBLIQUE.floatValue();
                continue;
            }
            if (element.equalsIgnoreCase("100")) {
                weight = TextAttribute.WEIGHT_EXTRA_LIGHT;
                continue;
            }
            if (element.equalsIgnoreCase("200")) {
                weight = TextAttribute.WEIGHT_LIGHT;
                continue;
            }
            if (element.equalsIgnoreCase("300")) {
                weight = TextAttribute.WEIGHT_DEMILIGHT;
                continue;
            }
            if (element.equalsIgnoreCase("lighter")) {
                weight = TextAttribute.WEIGHT_DEMILIGHT;
                continue;
            }
            if (element.equalsIgnoreCase("400")) {
                weight = TextAttribute.WEIGHT_REGULAR;
                continue;
            }
            if (element.equalsIgnoreCase("500")) {
                weight = TextAttribute.WEIGHT_SEMIBOLD;
                continue;
            }
            if (element.equalsIgnoreCase("600")) {
                weight = TextAttribute.WEIGHT_DEMIBOLD;
                continue;
            }
            if (element.equalsIgnoreCase("700")) {
                weight = TextAttribute.WEIGHT_BOLD;
                continue;
            }
            if (element.equalsIgnoreCase("800")) {
                weight = TextAttribute.WEIGHT_HEAVY;
                continue;
            }
            if (element.equalsIgnoreCase("900")) {
                weight = TextAttribute.WEIGHT_EXTRABOLD;
                continue;
            }
            if (element.equalsIgnoreCase("bold")) {
                weight = TextAttribute.WEIGHT_BOLD;
                continue;
            }
            if (element.equalsIgnoreCase("bolder")) {
                weight = TextAttribute.WEIGHT_DEMIBOLD;
                continue;
            }
            if (fontSize == null) {
                String[] parts = element.split("/");
                fontSize = parts[0];
                continue;
            }
            fontFamily = element;
            for (int j = i + 1; j < elements.length; ++j) {
                fontFamily = fontFamily + " " + elements[j];
            }
            break;
        }
        HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>();
        attributes.put(TextAttribute.FAMILY, fontFamily);
        attributes.put(TextAttribute.WEIGHT, weight);
        attributes.put(TextAttribute.SIZE, Float.valueOf(FontUtil.parseFontSizeOfPx(fontSize)));
        attributes.put(TextAttribute.POSTURE, Float.valueOf(italic));
        return new Font(attributes);
    }

    public static float parseFontSizeOfPx(String fontSize) {
        if (fontSize == null || fontSize.length() == 0) {
            return -1.0f;
        }
        int index = fontSize.indexOf("px");
        if (index > 0) {
            float px = Float.parseFloat(fontSize.substring(0, index));
            return px;
        }
        index = fontSize.indexOf("em");
        if (index > 0) {
            float em = Float.parseFloat(fontSize.substring(0, index));
            return em * 16.0f;
        }
        index = fontSize.indexOf("pt");
        if (index > 0) {
            float pt = Float.parseFloat(fontSize.substring(0, index));
            return pt * 96.0f / 72.0f;
        }
        float medium = 16.0f;
        if (fontSize.equalsIgnoreCase("xx-small")) {
            return medium / 1.728f;
        }
        if (fontSize.equalsIgnoreCase("x-small")) {
            return medium / 1.414f;
        }
        if (fontSize.equalsIgnoreCase("small")) {
            return medium / 1.2f;
        }
        if (fontSize.equalsIgnoreCase("medium")) {
            return medium;
        }
        if (fontSize.equalsIgnoreCase("large")) {
            return medium * 1.2f;
        }
        if (fontSize.equalsIgnoreCase("x-large")) {
            return medium * 1.414f;
        }
        if (fontSize.equalsIgnoreCase("xx-large")) {
            return medium * 1.728f;
        }
        return 16.0f;
    }
}

