/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.jsengine.mock;

import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.imglib.IGetImgContentStrategy;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class Image {
    private BufferedImage image;
    private String imglibHead = "imglib://";
    public Integer[] myRect;
    public String myState = "error";
    public String onload;
    public String onerror;

    public void setAttribute(String key, String value) {
        try {
            if ("src".equals(key)) {
                this.image = this.getImageByUrl(value);
                if (this.image != null) {
                    this.myState = "success";
                }
            }
        }
        catch (Exception e) {
            LogUtil.error("get image error:" + value, e);
        }
    }

    private BufferedImage getImageByUrl(String value) throws IOException {
        if (value.startsWith(this.imglibHead)) {
            String fullPath = value.substring(this.imglibHead.length());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("fullPath", fullPath);
            return this.getImgContentByParams(params);
        }
        URL url = new URL(value);
        Map<String, String> params = this.createParams(url.getQuery());
        if (QingPersistentFileType.IMAGE_LIBRARY.getSubFolder().equals(params.get("fileType")) && StringUtils.isNotEmpty(params.get("fileName"))) {
            return this.getImgContentByParams(params);
        }
        return ImageIO.read(url);
    }

    private BufferedImage getImgContentByParams(Map<String, String> params) throws IOException {
        IGetImgContentStrategy strategy = CustomStrategyRegistrar.getStrategy(IGetImgContentStrategy.class);
        return strategy.getImgContentByParams(params);
    }

    private Map<String, String> createParams(String query) {
        String[] pairs;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String pair : pairs = query.split("&")) {
            String[] keyValue = pair.split("=");
            String key = keyValue[0];
            String value = keyValue[1];
            params.put(key, value);
        }
        return params;
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

