/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.jsengine.mock;

import com.kingdee.bos.qing.common.jsengine.model.IArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class JsArray
extends ArrayList
implements IArray {
    public int length;

    public JsArray() {
    }

    public JsArray(int initialCapacity) {
        super(initialCapacity);
    }

    public JsArray(Object[] array) {
        if (array != null && array.length > 0) {
            super.addAll(Arrays.asList(array));
        }
        this.length = super.size();
    }

    public JsArray(Collection c) {
        if (c != null && !c.isEmpty()) {
            super.addAll(c);
        }
        this.length = super.size();
    }

    public JsArray concat(Object ... arrayX) {
        JsArray arrNew = new JsArray();
        arrNew.addAll((Collection)this);
        if (arrayX != null) {
            int len = arrayX.length;
            for (int i = 0; i < len; ++i) {
                if (arrayX[i] instanceof JsArray) {
                    arrNew.addAll((Collection)((JsArray)arrayX[i]));
                    continue;
                }
                arrNew.add(arrayX[i]);
            }
        }
        return arrNew;
    }

    public String join() {
        return this.join(",");
    }

    public String join(String split) {
        if (this.length == 0) {
            return "";
        }
        if (split == null || "undefined".equals(split)) {
            split = ",";
        }
        StringBuilder value = new StringBuilder();
        if (this.length > 0) {
            value.append(this.get(0));
            for (int i = 1; i < this.length; ++i) {
                value.append(split);
                value.append(this.get(i));
            }
        }
        return value.toString();
    }

    public Object push(Object ... newObjects) {
        this.addAll(Arrays.asList(newObjects));
        return this.size();
    }

    public Object pop() {
        if (this.size() < 1) {
            return null;
        }
        return this.remove(this.length - 1);
    }

    public JsArray reverse() {
        Collections.reverse(this);
        return this;
    }

    public Object shift() {
        if (this.size() < 1) {
            return null;
        }
        return this.remove(0);
    }

    public JsArray slice() {
        return this.slice(0, this.size());
    }

    public JsArray slice(int begin) {
        return this.slice(begin, this.size());
    }

    public JsArray slice(int begin, int end) {
        this.length = this.size();
        return new JsArray((Collection)this.subList(this.getRealIndex(begin), this.getRealIndex(end)));
    }

    public JsArray splice(int index, int deleteCount, Object ... items) {
        this.length = this.size();
        index = this.getRealIndex(index);
        if (deleteCount > 0 && index < this.length) {
            int toIndex = index + deleteCount;
            if (toIndex > this.length) {
                toIndex = this.length;
            }
            this.removeRange(index, toIndex);
        }
        if (items != null && items.length > 0) {
            this.addAll(index, Arrays.asList(items));
        }
        return this;
    }

    public JsArray splice(int index, int deleteCount) {
        return this.splice(index, deleteCount, new Object[0]);
    }

    private int getRealIndex(int index) {
        if (index < 0 && (index = this.length + index) < 0) {
            index = 0;
        }
        if (index >= this.length) {
            index = this.length;
        }
        return index;
    }

    public JsArray sort() {
        Collections.sort(this);
        return this;
    }

    @Override
    public String toString() {
        return this.join(",");
    }

    public Object unshift(Object ... newObjects) {
        this.addAll(0, Arrays.asList(newObjects));
        return this.size();
    }

    @Override
    public boolean add(Object e) {
        boolean result = super.add(e);
        this.length = this.size();
        return result;
    }

    @Override
    public void add(int index, Object element) {
        super.add(index, element);
        this.length = this.size();
    }

    @Override
    public boolean addAll(Collection c) {
        boolean result = super.addAll(c);
        this.length = this.size();
        return result;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        boolean result = super.addAll(index, c);
        this.length = this.size();
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.length = this.size();
    }

    @Override
    public Object remove(int index) {
        Object result = super.remove(index);
        this.length = this.size();
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        this.length = this.size();
        return result;
    }
}

