/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.jsengine.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColorTransUtil {
    private static HashMap<String, Color> colorMap = new HashMap(16);

    public static Color HSL2Color(String hsl) {
        Color color = null;
        if (hsl != null && hsl.startsWith("hsl(")) {
            double B;
            double G;
            double R;
            float H = 0.0f;
            float S = 0.0f;
            float L = 0.0f;
            String hslValue = hsl.substring("hsl(".length(), hsl.length() - ")".length()).trim();
            String[] split = hslValue.split(",");
            H = Float.parseFloat(split[0]) / 360.0f;
            S = split[1].endsWith("%") ? Float.parseFloat(split[1].substring(0, split[1].length() - 1)) / 100.0f : Float.parseFloat(split[1]);
            L = split[2].endsWith("%") ? Float.parseFloat(split[2].substring(0, split[2].length() - 1)) / 100.0f : Float.parseFloat(split[2]);
            if (S == 0.0f) {
                R = (double)L * 255.0;
                G = (double)L * 255.0;
                B = (double)L * 255.0;
            } else {
                double var_2 = (double)L < 0.5 ? (double)(L * (1.0f + S)) : (double)(L + S - S * L);
                double var_1 = 2.0 * (double)L - var_2;
                R = 255.0 * ColorTransUtil.Hue2RGB(var_1, var_2, (double)H + 0.3333333333333333);
                G = 255.0 * ColorTransUtil.Hue2RGB(var_1, var_2, H);
                B = 255.0 * ColorTransUtil.Hue2RGB(var_1, var_2, (double)H - 0.3333333333333333);
            }
            color = new Color((int)R, (int)G, (int)B);
        }
        return color;
    }

    private static double Hue2RGB(double v1, double v2, double vH) {
        if (vH < 0.0) {
            vH += 1.0;
        }
        if (vH > 1.0) {
            vH -= 1.0;
        }
        if (6.0 * vH < 1.0) {
            return v1 + (v2 - v1) * 6.0 * vH;
        }
        if (2.0 * vH < 1.0) {
            return v2;
        }
        if (3.0 * vH < 2.0) {
            return v1 + (v2 - v1) * (0.6666666666666666 - vH) * 6.0;
        }
        return v1;
    }

    public static Color parseString(String colorStr) throws RuntimeException {
        if (colorStr == null) {
            return null;
        }
        Color c = colorMap.get(colorStr);
        if (c != null) {
            return c;
        }
        if (colorStr.startsWith("#")) {
            if (colorStr.length() == 7) {
                int rgb = Integer.parseInt(colorStr.substring(1, 7), 16);
                return new Color(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
            }
            if (colorStr.length() == 4) {
                String color = colorStr.substring(1, 4);
                return new Color(Integer.parseInt(color.substring(0, 1), 16) * 17, Integer.parseInt(color.substring(1, 2), 16) * 17, Integer.parseInt(color.substring(2, 3), 16) * 17);
            }
            if (colorStr.length() > 7) {
                int rgb = Integer.parseInt(colorStr.substring(1, 7), 16);
                int alpha = Integer.parseInt(colorStr.substring(7, 9), 16);
                return new Color(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, alpha & 0xFF);
            }
        } else if (colorStr.startsWith("rgba")) {
            colorStr = colorStr.replaceAll("\\s*|\t|\n", "");
            Matcher m = Pattern.compile("rgba\\((\\d+)\\,(\\d+)\\,(\\d+)\\,([0,1]\\.?([0-9]+)?)\\)", 2).matcher(colorStr);
            Matcher m1 = Pattern.compile("rgba\\((\\d+)\\,(\\d+)\\,(\\d+)\\,(\\d+)\\)", 2).matcher(colorStr);
            if (m.find()) {
                String r = m.group(1);
                String g = m.group(2);
                String b = m.group(3);
                String alpha = m.group(4);
                return new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b), Math.round(255.0f * Float.parseFloat(alpha)));
            }
            if (m1.find()) {
                String r = m1.group(1);
                String g = m1.group(2);
                String b = m1.group(3);
                String alpha = m1.group(4);
                return new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b), Integer.parseInt(alpha));
            }
        } else if (colorStr.startsWith("rgb")) {
            colorStr = colorStr.replaceAll("\\s*|\t|\n", "");
            Matcher m = Pattern.compile("rgb\\((\\d+)\\,(\\d+)\\,(\\d+)\\)", 2).matcher(colorStr);
            if (m.find()) {
                String r = m.group(1);
                String g = m.group(2);
                String b = m.group(3);
                return new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
            }
        } else {
            if (colorStr.startsWith("hsl")) {
                return ColorTransUtil.HSL2Color(colorStr);
            }
            int i = Integer.parseInt(colorStr, 16);
            return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
        }
        throw new RuntimeException("UnKnown color string: " + colorStr);
    }

    static {
        colorMap.put("black", Color.black);
        colorMap.put("blue", Color.blue);
        colorMap.put("cyan", Color.cyan);
        colorMap.put("red", Color.red);
        colorMap.put("gray", Color.gray);
        colorMap.put("dark_gray", Color.DARK_GRAY);
        colorMap.put("light_gray", Color.LIGHT_GRAY);
        colorMap.put("red", Color.red);
        colorMap.put("green", Color.green);
        colorMap.put("magenta", Color.magenta);
        colorMap.put("orange", Color.orange);
        colorMap.put("pink", Color.pink);
        colorMap.put("white", Color.white);
        colorMap.put("yellow", Color.yellow);
    }
}

