/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.limitation;

import com.kingdee.bos.qing.common.limitation.ITokenSizeSuggester;
import com.kingdee.bos.qing.common.limitation.LimitScene;
import com.kingdee.bos.qing.common.memory.MemWarningLevel;
import com.kingdee.bos.qing.datasource.join.config.QingJoinConfig;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;

public class ConfiguredTokenSizeSuggester
implements ITokenSizeSuggester {
    private Map<String, Integer> limitMap;

    public ConfiguredTokenSizeSuggester(LimitScene scene) {
        switch (scene) {
            case BIZ_ENTITY_QUERY: {
                String configs = System.getProperty("qing.bizentity.query.token.limitation");
                if (null != configs) {
                    this.loadFromConfig(configs);
                    break;
                }
                this.limitMap = this.initLimitMap();
                break;
            }
            default: {
                this.limitMap = this.initLimitMap();
            }
        }
    }

    private void loadFromConfig(String configs) {
        Map tmpMap = JsonUtil.decodeFromString(configs, Map.class);
        this.limitMap = new HashMap<String, Integer>();
        for (String key : tmpMap.keySet()) {
            Double value = (Double)tmpMap.get(key);
            if (null == value) continue;
            this.limitMap.put(key, value.intValue());
        }
    }

    private Map<String, Integer> initLimitMap() {
        HashMap<String, Integer> limitMap = new HashMap<String, Integer>(5);
        limitMap.put(MemWarningLevel.RED.name(), 0);
        limitMap.put(MemWarningLevel.ORANGE.name(), 2);
        limitMap.put(MemWarningLevel.YELLOW.name(), 5);
        limitMap.put(MemWarningLevel.BLUE.name(), 10);
        limitMap.put(MemWarningLevel.NORMAL.name(), 20);
        return limitMap;
    }

    @Override
    public int suggestSize(MemWarningLevel warningLevel) {
        if (!QingJoinConfig.getInstance().isMemMonitorOpened()) {
            return this.limitMap.get(MemWarningLevel.NORMAL.name());
        }
        Integer size = this.limitMap.get(warningLevel.name());
        return size == null ? 20 : size;
    }
}

