/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.limitation;

import com.kingdee.bos.qing.common.limitation.DynamicTokenLimiter;
import com.kingdee.bos.qing.common.limitation.ITokenSizeSuggester;
import com.kingdee.bos.qing.common.limitation.LimitScene;
import com.kingdee.bos.qing.common.limitation.StaticTokenLimiter;
import com.kingdee.bos.qing.common.memory.MemRuntimeMonitor;
import com.kingdee.bos.qing.datasource.join.config.QingJoinConfig;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class TokenLimiter {
    protected static final String LOG_PREFIX = "Qing-QueryToken:";
    private static final Map<LimitScene, TokenLimiter> limiters = new HashMap<LimitScene, TokenLimiter>();
    private long lastTouchTime;
    protected LimitScene scene;

    protected void touch() {
        this.lastTouchTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TokenLimiter getOrCreateLimiter(LimitScene scene, ITokenSizeSuggester sizeSuggester) {
        boolean isMemoryMonitorOpen = QingJoinConfig.getInstance().isMemMonitorOpened();
        Map<LimitScene, TokenLimiter> map = limiters;
        synchronized (map) {
            TokenLimiter limiter = limiters.get((Object)scene);
            if (null == limiter) {
                limiter = isMemoryMonitorOpen ? new DynamicTokenLimiter(scene, sizeSuggester) : new StaticTokenLimiter(scene);
                limiters.put(scene, limiter);
            } else {
                limiter.touch();
            }
            return limiter;
        }
    }

    public abstract void acquireToken() throws InterruptedException;

    public abstract void releaseToken();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy(LimitScene scene, String observerId) {
        Map<LimitScene, TokenLimiter> map = limiters;
        synchronized (map) {
            LogUtil.warn("destroy idle token limiter,id:" + observerId);
            limiters.remove((Object)scene);
            MemRuntimeMonitor.getInstance().unRegister(observerId);
        }
    }
}

