/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.client;

import com.kingdee.bos.qing.common.rpc.client.IQRpcInvokeResultGroupFuture;
import com.kingdee.bos.qing.common.rpc.client.InvocationResultGroupFutureImpl;
import com.kingdee.bos.qing.common.rpc.client.QRpcInvokeCallBack;
import com.kingdee.bos.qing.common.rpc.codec.CodecProtocol;
import com.kingdee.bos.qing.common.rpc.codec.IPToCodecVersionMap;
import com.kingdee.bos.qing.common.rpc.codec.QRpcVersionMsgCodec;
import com.kingdee.bos.qing.common.rpc.codec.QRpcVersionMsgCodecV2;
import com.kingdee.bos.qing.common.rpc.codec.RpcMsgCodecFactory;
import com.kingdee.bos.qing.common.rpc.codec.serialization.SerializationType;
import com.kingdee.bos.qing.common.rpc.codec.serialization.inbound.QRpcInvokeMsgDecoder;
import com.kingdee.bos.qing.common.rpc.codec.serialization.outbound.QRpcInvokeMsgEncoder;
import com.kingdee.bos.qing.common.rpc.common.QRpcSystemApp;
import com.kingdee.bos.qing.common.rpc.exception.QRpcConnectException;
import com.kingdee.bos.qing.common.rpc.handler.MessageClientHandler;
import com.kingdee.bos.qing.common.rpc.handler.QRpcErrorHandler;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvocation;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvokeFuture;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvokeResult;
import com.kingdee.bos.qing.common.rpc.model.QRpcMessage;
import com.kingdee.bos.qing.common.rpc.model.QRpcResultStatus;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.NetUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRpcClient {
    private static final Logger log = LoggerFactory.getLogger((String)QRpcClient.class.getName());
    private static AtomicInteger deliverIdCounter = new AtomicInteger(1);
    private Channel channel;
    private EventLoopGroup group;
    private AtomicLong msgSeq = new AtomicLong(0L);
    private String remoteAddress;
    private int remotePort;
    private IQRpcInvokeResultGroupFuture resultGrpFuture;
    private QRpcSystemApp systemApp;
    private String localIp;

    public QRpcClient(QRpcSystemApp systemApp) throws IOException {
        this.systemApp = systemApp;
        this.localIp = NetUtil.getValidLocalIp();
        if (NetUtil.isLoopOrNullIp(this.localIp)) {
            throw new IOException("local ip is null or loop ip");
        }
        String deliverId = this.localIp + "-deliverId:" + deliverIdCounter.getAndIncrement();
        this.resultGrpFuture = new InvocationResultGroupFutureImpl(deliverId);
        RpcMsgCodecFactory.regCodec((byte)11, new QRpcVersionMsgCodec());
        RpcMsgCodecFactory.regCodec((byte)12, new QRpcVersionMsgCodecV2());
    }

    public QRpcSystemApp getSystemApp() {
        return this.systemApp;
    }

    public void connect(String remoteServer, int port, int timeout) throws QRpcConnectException {
        this.group = new NioEventLoopGroup();
        this.remoteAddress = remoteServer;
        this.remotePort = port;
        Bootstrap bootstrap = this.initBootStrap(timeout);
        ChannelFuture future = bootstrap.connect(remoteServer, port);
        final AtomicReference error = new AtomicReference();
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (!channelFuture.isSuccess()) {
                    error.set(channelFuture.cause());
                } else {
                    QRpcClient.this.channel = channelFuture.channel();
                }
            }
        });
        try {
            future.sync();
        }
        catch (Exception e) {
            log.error("QingRPC:connect to remote server interrupted", (Throwable)e);
        }
        if (error.get() != null) {
            throw new QRpcConnectException("connect to server failed", (Throwable)error.get());
        }
        log.info("QingRPC:connect succeed ,target host:" + remoteServer + ",port:" + port);
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void asyncSendReq(QRpcInvocation req, QRpcInvokeCallBack callBack) {
        final long seq = this.msgSeq.incrementAndGet();
        try {
            this.checkChannelUsable();
        }
        catch (QRpcConnectException e) {
            if (null != callBack) {
                callBack.onInvoked(QRpcInvokeResult.disconnectedResp(e));
            }
            return;
        }
        req.setDeliverId(this.resultGrpFuture.getId());
        if (null != callBack) {
            this.resultGrpFuture.newFuture(seq, callBack);
        }
        final QRpcMessage dppMessage = this.createRpcMsg(seq, req);
        ChannelPromise promise = this.channel.newPromise();
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (!channelFuture.isSuccess()) {
                    Throwable throwable = channelFuture.cause();
                    QRpcInvokeResult errorResp = new QRpcInvokeResult();
                    errorResp.setStatus(QRpcResultStatus.SEND_FAILED);
                    errorResp.setError(throwable);
                    if (!QRpcClient.this.resultGrpFuture.existSubFuture(seq)) {
                        LogUtil.error("QingRPC:async send msg failed,msgSeq=" + dppMessage.getSeq() + ",content=" + dppMessage.getData().toString(), throwable);
                    } else {
                        QRpcClient.this.resultGrpFuture.setFutureResult(seq, errorResp);
                    }
                } else {
                    LogUtil.info("QingRPC:async send invocation request succeed,msgSeq=" + dppMessage.getSeq() + ",content=" + dppMessage.getData().toString());
                }
            }
        });
        this.channel.writeAndFlush((Object)dppMessage, promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QRpcInvokeResult sendReq(QRpcInvocation req, long timeout) {
        try {
            this.checkChannelUsable();
        }
        catch (QRpcConnectException e) {
            return QRpcInvokeResult.disconnectedResp(e);
        }
        long seq = this.msgSeq.incrementAndGet();
        req.setDeliverId(this.resultGrpFuture.getId());
        final QRpcInvokeFuture future = this.resultGrpFuture.newFuture(seq, null);
        final QRpcMessage qRpcMessage = this.createRpcMsg(seq, req);
        ChannelPromise promise = this.channel.newPromise();
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (!channelFuture.isSuccess()) {
                    Throwable throwable = channelFuture.cause();
                    QRpcInvokeResult errorResp = new QRpcInvokeResult();
                    errorResp.setStatus(QRpcResultStatus.SEND_FAILED);
                    errorResp.setError(throwable);
                    errorResp.setSeq(qRpcMessage.getSeq());
                    errorResp.setErrInfo("qrpc message send failed,msgSeq=" + qRpcMessage.getSeq());
                    future.setResult(errorResp);
                }
            }
        });
        try {
            Object object = this;
            synchronized (object) {
                this.channel.writeAndFlush((Object)qRpcMessage, promise);
                promise.sync();
                LogUtil.info("QingRPC:send invocation request to target:" + this.remoteAddress + ",msgSeq=" + qRpcMessage.getSeq() + ",method=" + req.getMethod() + ",deliverId=" + req.getDeliverId());
            }
            object = future.getResult(timeout, this);
            return object;
        }
        catch (Exception e) {
            QRpcInvokeResult errorResp = new QRpcInvokeResult();
            errorResp.setStatus(QRpcResultStatus.SEND_FAILED);
            errorResp.setError(e);
            errorResp.setSeq(qRpcMessage.getSeq());
            QRpcInvokeResult qRpcInvokeResult = errorResp;
            return qRpcInvokeResult;
        }
        finally {
            this.resultGrpFuture.removeFuture(seq);
        }
    }

    private QRpcMessage createRpcMsg(long seq, QRpcInvocation req) {
        byte rpcVersion = IPToCodecVersionMap.getCodecVersion(this.remoteAddress);
        switch (rpcVersion) {
            case 11: {
                byte compressType = CodecProtocol.getCompressionType().getType();
                byte serializeType = SerializationType.KRYO.getType();
                return new QRpcMessage(seq, compressType, serializeType, 11, req);
            }
            case 12: {
                byte compressTypeV2 = CodecProtocol.getCompressionType().getType();
                byte serializeTypeV2 = SerializationType.KRYO_V2.getType();
                return new QRpcMessage(seq, compressTypeV2, serializeTypeV2, 12, req);
            }
        }
        return new QRpcMessage(seq, req);
    }

    private void checkChannelUsable() throws QRpcConnectException {
        if (!this.isAlive()) {
            throw new QRpcConnectException("request can not be send ,because channel is closed");
        }
    }

    public boolean isAlive() {
        return null != this.channel && this.channel.isActive();
    }

    private void setInvocationFailedOnClosed(Set<Long> currentWaitingSeqs) {
        for (long seq : currentWaitingSeqs) {
            QRpcInvokeResult invokeResult = new QRpcInvokeResult();
            invokeResult.setSeq(seq);
            invokeResult.setStatus(QRpcResultStatus.CONNECT_ERROR);
            invokeResult.setErrInfo("can not receive response on rpc client will be closed, seq:" + seq + ", deliverId:" + this.resultGrpFuture.getId());
            invokeResult.setError(new QRpcConnectException("current rpc connection is not alive"));
            invokeResult.setReceiverId(this.resultGrpFuture.getId());
            this.resultGrpFuture.setFutureResult(seq, invokeResult);
        }
    }

    public void close() {
        Set<Long> currentWaitingSeqs = this.resultGrpFuture.getCurrentWaitingSeqs();
        log.info("close qing rpc client, id:" + this.resultGrpFuture.getId() + ", current unfinished request seqs:" + currentWaitingSeqs);
        this.setInvocationFailedOnClosed(currentWaitingSeqs);
        if (null != this.channel) {
            try {
                ChannelFuture cf = this.channel.close();
                cf.sync();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (null != this.group) {
            this.group.shutdownGracefully();
        }
    }

    private Bootstrap initBootStrap(int timeout) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0, 30, 0)});
                ch.pipeline().addLast(new ChannelHandler[]{new QRpcInvokeMsgDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new QRpcInvokeMsgEncoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new MessageClientHandler(QRpcClient.this.resultGrpFuture, IPToCodecVersionMap.getCodecVersion(QRpcClient.this.remoteAddress))});
                ch.pipeline().addLast(new ChannelHandler[]{new QRpcErrorHandler()});
            }
        })).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(1024, 4196, 65536))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeout);
        return bootstrap;
    }
}

