/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.codec.serialization.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.kingdee.bos.qing.common.rpc.codec.serialization.inbound.ObjectInput;
import com.kingdee.bos.qing.common.rpc.codec.serialization.kryo.KryoPool;
import com.kingdee.bos.qing.common.rpc.exception.QRpcCodecException;
import java.io.InputStream;

public class KryoDataInput
implements ObjectInput {
    private Kryo kryo;
    private Input input;

    public KryoDataInput(byte rpcVersion, InputStream stream) throws Exception {
        this.input = new Input(stream);
        this.kryo = KryoPool.getInstance().borrowKryo(rpcVersion);
    }

    @Override
    public <T> T readObject(Class<T> type) throws QRpcCodecException {
        if (null == this.kryo) {
            throw new QRpcCodecException("kryo is null ,read failed");
        }
        try {
            return type.cast(this.kryo.readClassAndObject(this.input));
        }
        catch (Exception e) {
            throw new QRpcCodecException("read object failed,type:" + type.getName(), e);
        }
    }

    @Override
    public void close() {
        if (null != this.input) {
            this.input.close();
        }
        KryoPool.getInstance().returnCurrentThreadKryo();
    }
}

