/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.codec.serialization.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.kingdee.bos.qing.common.rpc.codec.serialization.kryo.KryoPool;
import com.kingdee.bos.qing.common.rpc.codec.serialization.outbound.ObjectOutput;
import com.kingdee.bos.qing.common.rpc.exception.QRpcCodecException;
import java.io.OutputStream;

public class KryoDataOutput
implements ObjectOutput {
    private Kryo kryo;
    private Output output;

    public KryoDataOutput(byte rpcVersion, OutputStream outputStream) throws Exception {
        this.output = new Output(outputStream);
        this.kryo = KryoPool.getInstance().borrowKryo(rpcVersion);
    }

    @Override
    public void writeObject(Object obj) throws QRpcCodecException {
        if (null == this.kryo) {
            throw new QRpcCodecException("kryo is null ,write failed");
        }
        try {
            this.kryo.writeClassAndObject(this.output, obj);
        }
        catch (Exception e) {
            throw new QRpcCodecException("write object failed by kryo", e);
        }
    }

    @Override
    public void flush() {
        this.output.flush();
    }

    @Override
    public void close() {
        if (null != this.output) {
            this.output.close();
        }
        KryoPool.getInstance().returnCurrentThreadKryo();
    }
}

