/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.codec.serialization.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.kingdee.bos.qing.common.rpc.codec.serialization.kryo.KryoFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class KryoPool {
    private static final KryoPool instance = new KryoPool();
    private Map<Byte, GenericObjectPool<Kryo>> kryoPoolByVersion = new HashMap<Byte, GenericObjectPool<Kryo>>(2);
    private static ThreadLocal<Kryo> kryoThreadLocal = new ThreadLocal();
    private static ThreadLocal<Byte> rpcVersionThreadLocal = new ThreadLocal();

    public static KryoPool getInstance() {
        return instance;
    }

    private KryoPool() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxIdle(100);
        config.setMinIdle(10);
        config.setMaxTotal(500);
        config.setBlockWhenExhausted(true);
        this.kryoPoolByVersion.put((byte)11, (GenericObjectPool<Kryo>)new GenericObjectPool((PooledObjectFactory)new KryoFactory(11), config));
        this.kryoPoolByVersion.put((byte)12, (GenericObjectPool<Kryo>)new GenericObjectPool((PooledObjectFactory)new KryoFactory(12), config));
    }

    public Kryo borrowKryo(byte rpcVersion) throws Exception {
        Kryo kryoInThread = kryoThreadLocal.get();
        if (null == kryoInThread) {
            GenericObjectPool<Kryo> pool = this.kryoPoolByVersion.get(rpcVersion);
            kryoInThread = (Kryo)pool.borrowObject();
            kryoThreadLocal.set(kryoInThread);
            rpcVersionThreadLocal.set(rpcVersion);
        }
        return kryoInThread;
    }

    public void returnCurrentThreadKryo() {
        Kryo kryo = kryoThreadLocal.get();
        if (kryo != null) {
            this.returnKryo(kryo);
            kryoThreadLocal.set(null);
            rpcVersionThreadLocal.set(null);
        }
    }

    private void returnKryo(Kryo kryo) {
        byte rpcVersion = rpcVersionThreadLocal.get();
        GenericObjectPool<Kryo> pool = this.kryoPoolByVersion.get(rpcVersion);
        pool.returnObject((Object)kryo);
    }
}

