/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.handler;

import com.kingdee.bos.qing.common.rpc.codec.serialization.kryo.KryoPool;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRpcErrorHandler
extends ChannelDuplexHandler {
    private static final Logger log = LoggerFactory.getLogger((String)QRpcErrorHandler.class.getName());

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause.getMessage().contains("Connection reset by peer")) {
            ctx.channel().close();
        } else {
            log.error("qrpc exception caught,target:" + ctx.channel().remoteAddress().toString(), cause);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (!channelFuture.isSuccess()) {
                    log.error("QingRPC:write msg error", channelFuture.cause());
                }
            }
        }));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        KryoPool.getInstance().returnCurrentThreadKryo();
        super.channelInactive(ctx);
    }
}

