/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.model;

import com.kingdee.bos.qing.common.rpc.client.QRpcClient;
import com.kingdee.bos.qing.common.rpc.client.QRpcInvokeCallBack;
import com.kingdee.bos.qing.common.rpc.model.QRpcInvokeResult;
import com.kingdee.bos.qing.common.rpc.model.QRpcResultStatus;

public class QRpcInvokeFuture {
    private final Object syncLock = new Object();
    private volatile QRpcInvokeResult invokeResult;
    private QRpcInvokeCallBack callBack;
    private long seq;
    private String receiverId;

    public QRpcInvokeFuture(long seq, String receiverId, QRpcInvokeCallBack callBack) {
        this.callBack = callBack;
        this.seq = seq;
        this.receiverId = receiverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(QRpcInvokeResult result) {
        this.invokeResult = result;
        Object object = this.syncLock;
        synchronized (object) {
            this.syncLock.notifyAll();
        }
        if (null != this.callBack) {
            this.callBack.onInvoked(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QRpcInvokeResult getResult() throws InterruptedException {
        while (null == this.invokeResult) {
            Object object = this.syncLock;
            synchronized (object) {
                this.syncLock.wait();
            }
        }
        return this.invokeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QRpcInvokeResult getResult(long timeoutInMilli, QRpcClient rpcClient) throws InterruptedException {
        long totalTime = 0L;
        long waitTime = 15000L;
        while (null == this.invokeResult) {
            Object object = this.syncLock;
            synchronized (object) {
                this.syncLock.wait(waitTime);
                totalTime += waitTime;
            }
            if (null != this.invokeResult) break;
            boolean isAlive = rpcClient.isAlive();
            if (!isAlive) {
                QRpcInvokeResult resp = new QRpcInvokeResult();
                resp.setStatus(QRpcResultStatus.CONNECT_ERROR);
                resp.setSeq(this.seq);
                resp.setReceiverId(this.receiverId);
                resp.setError(new IllegalStateException("current rpc client is not alive , current invoke req can not receive result, seq:" + this.seq + ", deliverId:" + this.receiverId));
                return resp;
            }
            if (totalTime < timeoutInMilli) continue;
            return QRpcInvokeResult.timeoutResponse(this.seq, this.receiverId, timeoutInMilli);
        }
        return this.invokeResult;
    }
}

