/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.rpc.server;

import com.kingdee.bos.qing.common.rpc.codec.serialization.inbound.QRpcInvokeMsgDecoder;
import com.kingdee.bos.qing.common.rpc.codec.serialization.outbound.QRpcInvokeMsgEncoder;
import com.kingdee.bos.qing.common.rpc.common.QRpcConfiguration;
import com.kingdee.bos.qing.common.rpc.handler.MessageServerHandler;
import com.kingdee.bos.qing.common.rpc.handler.QRpcErrorHandler;
import com.kingdee.bos.qing.common.rpc.handler.ServerReadIdleEventHandler;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.NetUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class QRpcServer {
    private static final int UNSTARTED = 0;
    private static final int STARTING = 1;
    private static final int STARTED = 2;
    private Channel serverChannel;
    private String serverIp;
    private int serverPort;
    private AtomicInteger startStatus = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final int serverPort) throws Throwable {
        if (!this.startStatus.compareAndSet(0, 1)) {
            return;
        }
        this.serverIp = NetUtil.getValidLocalIp();
        if (NetUtil.isLoopOrNullIp(this.serverIp)) {
            throw new IOException("local ip is null or loop ip");
        }
        this.serverPort = serverPort;
        LogUtil.info("QingRPC:begin start qing rpc server,serverIp=" + this.serverIp + ",serverPort= " + serverPort);
        final AtomicReference<Object> startException = new AtomicReference<Object>(null);
        final CountDownLatch latch = new CountDownLatch(1);
        Thread startThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NioEventLoopGroup bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new ThreadPoolManage.NamedThreadFactory("Qing-Rpc-Server-Boss", true));
                NioEventLoopGroup workerGroup = new NioEventLoopGroup(QRpcConfiguration.getServerWorkThreadSize(), (ThreadFactory)new ThreadPoolManage.NamedThreadFactory("Qing-Rpc-Server-Worker", true));
                try {
                    ServerBootstrap boostrap = new ServerBootstrap();
                    ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)boostrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                        public void initChannel(SocketChannel ch) throws Exception {
                            ch.pipeline().addLast("idle", (ChannelHandler)new IdleStateHandler(300, 0, 0)).addLast("decoder", (ChannelHandler)new QRpcInvokeMsgDecoder()).addLast("encoder", (ChannelHandler)new QRpcInvokeMsgEncoder()).addLast("inbound", (ChannelHandler)new MessageServerHandler()).addLast("readIdle", (ChannelHandler)new ServerReadIdleEventHandler()).addLast("error", (ChannelHandler)new QRpcErrorHandler());
                        }
                    }).option(ChannelOption.SO_BACKLOG, (Object)100)).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(1024, 4196, 65536)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
                    ChannelFuture future = boostrap.bind(serverPort).sync();
                    QRpcServer.this.serverChannel = future.channel();
                    latch.countDown();
                    QRpcServer.this.serverChannel.closeFuture().sync();
                }
                catch (Throwable e) {
                    startException.set(e);
                    latch.countDown();
                }
                finally {
                    bossGroup.shutdownGracefully();
                    workerGroup.shutdownGracefully();
                }
            }
        });
        startThread.setName("Qing-Rpc-Server-Boot-Thread");
        startThread.start();
        try {
            latch.await();
            Throwable error = startException.get();
            if (null != error) {
                throw error;
            }
            LogUtil.info("QingRPC:start qing rpc server succeed");
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.startStatus.compareAndSet(1, 2);
        }
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isStarted() {
        return null != this.serverChannel && this.serverChannel.isActive();
    }
}

