/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.session;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.concurrent.TimeUnit;

public abstract class AbstractGlobalQingSession
implements IGlobalQingSession {
    private static final String DEFAULT_TIMEOUT_KEY = "qing.session.timeout";
    protected static final int DEFAULT_TIMEOUT = 300;

    protected int getDefaultTimeout() {
        String s = System.getProperty(DEFAULT_TIMEOUT_KEY);
        if (s != null) {
            try {
                return Integer.parseInt(s.trim());
            }
            catch (Throwable t) {
                LogUtil.error("qing.session.timeout is not legal integer: " + s);
            }
        }
        return 300;
    }

    @Override
    public final void set(String key, String value) {
        this.set(key, value, this.getDefaultTimeout(), TimeUnit.SECONDS);
    }

    @Override
    public final void hSet(String key, String subKey, String value) {
        this.hSet(key, subKey, value, this.getDefaultTimeout(), TimeUnit.SECONDS);
    }

    @Override
    public <T extends ISessionCacheable> void hSetCache(String key, T cacheable) {
        this.hSet(key, cacheable.getCacheKey(), cacheable.toJson(), cacheable.getTimeoutSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public <T extends ISessionCacheable> T hGetCache(String key, String subKey, Class<T> class1) {
        ISessionCacheable t;
        try {
            t = (ISessionCacheable)class1.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return (T)t.fromJson(this.hGet(key, subKey));
    }

    @Override
    public final <T extends ISessionCacheable> void setCache(T cacheable) {
        this.set(cacheable.getCacheKey(), cacheable.toJson(), cacheable.getTimeoutSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public final <T extends ISessionCacheable> T getCache(String cacheKey, Class<T> class1) {
        ISessionCacheable t;
        try {
            t = (ISessionCacheable)class1.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return (T)t.fromJson(this.get(cacheKey));
    }

    @Override
    public long incrBy(String key, int count) {
        throw new IllegalStateException("need override");
    }

    @Override
    public int addList(String key, String[] values) {
        return this.addList(key, values, this.getDefaultTimeout(), TimeUnit.SECONDS);
    }
}

