/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.session.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JVMMapCache {
    private long lastVisitTimeStamp = System.currentTimeMillis();
    private Map<String, String> sessionMap = new ConcurrentHashMap<String, String>();
    private Map<String, Long> sessionLongValueMap = new ConcurrentHashMap<String, Long>();
    private ConcurrentHashMap<String, Map<String, String>> sessionSubMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Set<String>> sessionSet = new ConcurrentHashMap();
    private ConcurrentHashMap<String, List<String>> sessionList = new ConcurrentHashMap();
    private Map<String, Long> sessionTimeStamp = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> sessionTimeout = new ConcurrentHashMap<String, Long>();
    private ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        long currentTimeStamp = System.currentTimeMillis();
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        try {
            writeLock.lock();
            Set<Map.Entry<String, Long>> entrySet = this.sessionTimeStamp.entrySet();
            long lastTimeStamp = 0L;
            long timeoutMillis = 0L;
            for (Map.Entry<String, Long> entry : entrySet) {
                lastTimeStamp = this.sessionTimeStamp.get(entry.getKey());
                if (!this.sessionTimeout.containsKey(entry.getKey()) || currentTimeStamp - lastTimeStamp <= (timeoutMillis = this.sessionTimeout.get(entry.getKey()).longValue())) continue;
                this.sessionTimeout.remove(entry.getKey());
                this.sessionTimeStamp.remove(entry.getKey());
                this.sessionMap.remove(entry.getKey());
                this.sessionLongValueMap.remove(entry.getKey());
                this.sessionSet.remove(entry.getKey());
                this.sessionList.remove(entry.getKey());
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.sessionMap.isEmpty();
    }

    public long getLastVisitTimeStamp() {
        return this.lastVisitTimeStamp;
    }

    private void updateTimeStamp(String keyInSession) {
        if (this.sessionTimeout.containsKey(keyInSession)) {
            this.sessionTimeStamp.put(keyInSession, System.currentTimeMillis());
        }
        this.lastVisitTimeStamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String keyInSession) {
        ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
        try {
            readLock.lock();
            this.updateTimeStamp(keyInSession);
            String string = this.sessionMap.get(keyInSession);
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSubKeys(String keyInSession) {
        ArrayList<String> subKeys = new ArrayList<String>(10);
        ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
        try {
            readLock.lock();
            this.updateTimeStamp(keyInSession);
            Map<String, String> subMap = this.sessionSubMap.get(keyInSession);
            if (subMap != null) {
                subKeys.addAll(subMap.keySet());
            }
        }
        finally {
            readLock.unlock();
        }
        return subKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String keyInSession, String subkeyInSession) {
        ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
        try {
            readLock.lock();
            this.updateTimeStamp(keyInSession);
            Map<String, String> subMap = this.sessionSubMap.get(keyInSession);
            if (subMap != null) {
                String string = subMap.get(subkeyInSession);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String keyInSession, String subkeyInSession) {
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        try {
            writeLock.lock();
            Map<String, String> subMap = this.sessionSubMap.get(keyInSession);
            if (subMap != null) {
                subMap.remove(subkeyInSession);
            }
            if (subMap == null || subMap.isEmpty()) {
                this.sessionTimeStamp.remove(keyInSession);
                this.sessionSubMap.remove(keyInSession);
                this.sessionTimeout.remove(keyInSession);
            }
            this.lastVisitTimeStamp = System.currentTimeMillis();
        }
        finally {
            writeLock.unlock();
        }
    }

    public void remove(String keyInSession) {
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        try {
            writeLock.lock();
            this.sessionTimeStamp.remove(keyInSession);
            this.sessionMap.remove(keyInSession);
            this.sessionSubMap.remove(keyInSession);
            this.sessionSet.remove(keyInSession);
            this.sessionList.remove(keyInSession);
            this.sessionTimeout.remove(keyInSession);
            this.sessionLongValueMap.remove(keyInSession);
            this.lastVisitTimeStamp = System.currentTimeMillis();
        }
        finally {
            writeLock.unlock();
        }
    }

    public void set(String keyInSession, String value, int timeout, TimeUnit timeUnit) {
        long timeoutMillis = 0L;
        if (timeout > 0) {
            timeoutMillis = timeUnit.toMillis(timeout);
        }
        this.set(keyInSession, value, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(String keyInSession, String value, long timeoutMillis) {
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        try {
            writeLock.lock();
            this.expireAfter(keyInSession, timeoutMillis);
            this.updateTimeStamp(keyInSession);
            this.sessionMap.put(keyInSession, value);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void set(String keyInSession, String subKeyInSession, String value, int timeout, TimeUnit timeUnit) {
        long timeoutMillis = 0L;
        if (timeout > 0) {
            timeoutMillis = timeUnit.toMillis(timeout);
        }
        this.set(keyInSession, subKeyInSession, value, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSetValues(String keyInSession, String[] removes) {
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        try {
            writeLock.lock();
            this.updateTimeStamp(keyInSession);
            Set<String> currentValues = this.sessionSet.get(keyInSession);
            if (null == currentValues || currentValues.size() == 0) {
                return;
            }
            for (int i = 0; i < removes.length; ++i) {
                if (null == removes[i]) continue;
                currentValues.remove(removes[i]);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSetValues(String keyInSession) {
        ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
        try {
            readLock.lock();
            this.updateTimeStamp(keyInSession);
            Set<String> values = this.sessionSet.get(keyInSession);
            if (values != null) {
                String[] stringArray = values.toArray(new String[0]);
                return stringArray;
            }
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToSet(String keyInSession, String[] values, int timeout, TimeUnit timeUnit) {
        if (null == values || values.length == 0) {
            return;
        }
        long timeoutMillis = 0L;
        if (timeout > 0) {
            timeoutMillis = timeUnit.toMillis(timeout);
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        try {
            writeLock.lock();
            this.expireAfter(keyInSession, timeoutMillis);
            this.updateTimeStamp(keyInSession);
            Set<String> currentValues = this.sessionSet.get(keyInSession);
            if (null == currentValues) {
                currentValues = new HashSet<String>(3);
                this.sessionSet.put(keyInSession, currentValues);
            }
            for (int i = 0; i < values.length; ++i) {
                if (null == values[i]) continue;
                currentValues.add(values[i]);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToSet(String keyInSession, String[] values) {
        if (null == values || values.length == 0) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        try {
            writeLock.lock();
            this.updateTimeStamp(keyInSession);
            Set<String> currentValues = this.sessionSet.get(keyInSession);
            if (null == currentValues) {
                currentValues = new HashSet<String>(3);
                this.sessionSet.put(keyInSession, currentValues);
            }
            for (int i = 0; i < values.length; ++i) {
                if (null == values[i]) continue;
                currentValues.add(values[i]);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(String keyInSession, String subKeyInSession, String value, long timeoutMillis) {
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        try {
            writeLock.lock();
            this.expireAfter(keyInSession, timeoutMillis);
            this.updateTimeStamp(keyInSession);
            Map<String, String> subMap = new ConcurrentHashMap();
            Map subMap2 = this.sessionSubMap.putIfAbsent(keyInSession, subMap);
            if (subMap2 != null) {
                subMap = subMap2;
            }
            if (value == null) {
                subMap.remove(subKeyInSession);
            } else {
                subMap.put(subKeyInSession, value);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void expireAfter(String keyInSession, long timeoutMillis) {
        if (timeoutMillis > 0L) {
            this.sessionTimeout.put(keyInSession, timeoutMillis);
        } else {
            this.sessionTimeout.remove(keyInSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrBy(String keyInSession, int value) {
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        try {
            writeLock.lock();
            Long currentValue = this.sessionLongValueMap.get(keyInSession);
            if (null == currentValue) {
                this.sessionLongValueMap.put(keyInSession, Long.valueOf(value));
                long l = value;
                return l;
            }
            long newValue = currentValue + (long)value;
            this.sessionLongValueMap.put(keyInSession, newValue);
            long l = newValue;
            return l;
        }
        finally {
            writeLock.unlock();
        }
    }

    public int addList(String keyInSession, String[] values, int timeout, TimeUnit timeUnit) {
        return this.insertList(keyInSession, Integer.MAX_VALUE, values, timeout, timeUnit);
    }

    public int insertList(String keyInSession, int index, String[] values) {
        return this.insertList(keyInSession, index, values, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertList(String keyInSession, int index, String[] values, int timeout, TimeUnit timeUnit) {
        if (null == values || values.length == 0) {
            return 0;
        }
        long timeoutMillis = -1L;
        if (timeout > 0) {
            timeoutMillis = timeUnit.toMillis(timeout);
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        try {
            writeLock.lock();
            this.expireAfter(keyInSession, timeoutMillis);
            this.updateTimeStamp(keyInSession);
            List<String> currentValues = this.sessionList.get(keyInSession);
            if (currentValues == null) {
                currentValues = new ArrayList<String>(8);
                this.sessionList.put(keyInSession, currentValues);
            }
            if (index == Integer.MAX_VALUE) {
                index = currentValues.size();
            }
            if (index < 0 || index > currentValues.size()) {
                int n = 0;
                return n;
            }
            currentValues.addAll(index, Arrays.asList(values));
        }
        finally {
            writeLock.unlock();
        }
        return values.length;
    }

    public void setListObject(String keyInSession, int index, String value) {
        this.insertList(keyInSession, index, new String[]{value});
    }

    public String getListObject(String keyInSession, int index) {
        String[] values = this.getList(keyInSession, index, 1);
        if (values.length > 0) {
            return values[0];
        }
        return null;
    }

    public String[] getList(String keyInSession) {
        return this.getList(keyInSession, 0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getList(String keyInSession, int index, int length) {
        ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
        try {
            readLock.lock();
            this.updateTimeStamp(keyInSession);
            List<String> values = this.sessionList.get(keyInSession);
            if (values != null) {
                int toIndex;
                int fromIndex;
                int stop = index + length - 1;
                int len = values.size();
                if (index >= 0) {
                    fromIndex = index;
                    if (fromIndex > len) {
                        String[] stringArray = new String[]{};
                        return stringArray;
                    }
                } else {
                    fromIndex = len + index;
                    if (fromIndex < 0) {
                        fromIndex = 0;
                    }
                }
                if (stop >= 0) {
                    toIndex = stop + 1;
                    if (toIndex < fromIndex) {
                        String[] stringArray = new String[]{};
                        return stringArray;
                    }
                    if (toIndex > len) {
                        toIndex = len;
                    }
                } else {
                    toIndex = len + stop + 1;
                    if (toIndex < fromIndex) {
                        String[] stringArray = new String[]{};
                        return stringArray;
                    }
                }
                String[] stringArray = values.subList(fromIndex, toIndex).toArray(new String[0]);
                return stringArray;
            }
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    public int getListLength(String keyInSession) {
        List<String> values = this.sessionList.get(keyInSession);
        if (values == null) {
            return 0;
        }
        return values.size();
    }

    public void removeListObject(String keyInSession, int index) {
        this.removeListObjects(keyInSession, index, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListObjects(String keyInSession, int index, int length) {
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        try {
            int toIndex;
            int fromIndex;
            writeLock.lock();
            this.updateTimeStamp(keyInSession);
            List<String> currentValues = this.sessionList.get(keyInSession);
            if (currentValues == null) {
                return;
            }
            int len = currentValues.size();
            if (index >= 0) {
                fromIndex = index;
                if (fromIndex > len) {
                    return;
                }
            } else {
                fromIndex = len + index;
                if (fromIndex < 0) {
                    fromIndex = 0;
                }
            }
            if ((toIndex = fromIndex + length) < fromIndex) {
                return;
            }
            if (toIndex > len) {
                toIndex = len;
            }
            currentValues.subList(fromIndex, toIndex).clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> popList(String keyInSession) {
        ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
        try {
            writeLock.lock();
            String[] data = this.getList(keyInSession);
            this.removeListObjects(keyInSession, 0, Integer.MAX_VALUE);
            List<String> list = Arrays.asList(data);
            return list;
        }
        finally {
            writeLock.unlock();
        }
    }
}

