/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.exception;

import com.kingdee.bos.qing.datasource.exception.DataSourceAccessException;
import com.kingdee.bos.qing.datasource.exception.DataSourceFileNotFoundException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceNoSpaceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceSizeLimitedException;
import com.kingdee.bos.qing.filesystem.exception.QingFileStorageLimitException;
import com.kingdee.bos.qing.filesystem.exception.QingFileStorageNoSpaceException;
import java.io.FileNotFoundException;

public abstract class AbstractDataSourceException
extends Exception {
    private static final long serialVersionUID = 7952267859154230643L;
    private int errorCode;

    public AbstractDataSourceException(String message) {
        super(message);
    }

    public AbstractDataSourceException(String message, Throwable cause) {
        super(message, cause);
    }

    public AbstractDataSourceException(Throwable cause) {
        super(cause);
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public static void accessExcetpion(Throwable e) throws AbstractDataSourceException {
        if (e instanceof AbstractDataSourceException) {
            throw (AbstractDataSourceException)e;
        }
        if (e instanceof FileNotFoundException) {
            throw new DataSourceFileNotFoundException(e);
        }
        throw new DataSourceAccessException(e);
    }

    public static void persistenceExcetpion(Throwable e) throws DataSourcePersistenceException {
        if (e instanceof DataSourcePersistenceException) {
            throw (DataSourcePersistenceException)e;
        }
        if (e instanceof QingFileStorageLimitException) {
            throw new DataSourcePersistenceSizeLimitedException(e);
        }
        if (e instanceof QingFileStorageNoSpaceException) {
            throw new DataSourcePersistenceNoSpaceException(e);
        }
        throw new DataSourcePersistenceException(e);
    }
}

