/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.meta;

import com.kingdee.bos.qing.datasource.exception.UnAnalysableException;
import com.kingdee.bos.qing.datasource.meta.DSElimination;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.DSMetaRelation;
import com.kingdee.bos.qing.datasource.model.graph.ERGraph;
import com.kingdee.bos.qing.datasource.model.graph.ERGraphUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DSMeta {
    private List<DSMetaEntity> entities;
    private List<DSMetaRelation> relations;
    private List<DSElimination> eliminations;

    public List<DSMetaEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<DSMetaEntity> entities) {
        this.entities = entities;
    }

    public List<DSElimination> getEliminations() {
        return this.eliminations;
    }

    public void setEliminations(List<DSElimination> eliminations) {
        this.eliminations = eliminations;
    }

    public List<DSMetaRelation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<DSMetaRelation> relations) {
        this.relations = relations;
    }

    public void fixEliminations(Set<DSFieldKey> allSelectedFieldKeys, Set<DSFieldKey> selectedMeasuresFieldKey) throws UnAnalysableException {
        if (selectedMeasuresFieldKey.isEmpty() || allSelectedFieldKeys.size() == 1) {
            if (this.eliminations != null) {
                this.eliminations.clear();
            }
            return;
        }
        if (this.eliminations != null) {
            HashSet<String> selectedMeasuresFieldKeySet = new HashSet<String>(16);
            for (DSFieldKey dsFieldKey : selectedMeasuresFieldKey) {
                selectedMeasuresFieldKeySet.add(dsFieldKey.toFullName());
            }
            ArrayList<DSElimination> newEliminations = new ArrayList<DSElimination>();
            for (DSElimination dsElimination : this.eliminations) {
                String idField = dsElimination.getIdField();
                ArrayList<String> newAssociatedFields = new ArrayList<String>();
                List<String> associatedFields = dsElimination.getAssociatedFields();
                for (String associatedField : associatedFields) {
                    if (!selectedMeasuresFieldKeySet.contains(associatedField)) continue;
                    newAssociatedFields.add(associatedField);
                }
                if (newAssociatedFields.size() <= 0) continue;
                DSElimination newDSElimination = new DSElimination();
                newDSElimination.setIdField(idField);
                newDSElimination.addAssociatedFields(newAssociatedFields);
                newEliminations.add(newDSElimination);
            }
            this.eliminations.clear();
            this.eliminations.addAll(newEliminations);
        } else {
            this.fixEliminationsFromGraph(allSelectedFieldKeys, selectedMeasuresFieldKey);
        }
    }

    private void fixEliminationsFromGraph(Set<DSFieldKey> allSelectedFieldKeys, Set<DSFieldKey> selectedMeasuresFieldKey) throws UnAnalysableException {
        if (this.relations == null || this.relations.isEmpty() || this.entities.size() <= 1) {
            return;
        }
        HashMap<String, DSMetaEntity> allDSMetaEntityMpas = new HashMap<String, DSMetaEntity>(this.entities.size(), 1.0f);
        HashMap allDSMetaPropertyMpas = new HashMap(this.entities.size(), 1.0f);
        for (DSMetaEntity dSMetaEntity : this.entities) {
            String dsMetaEntityName = dSMetaEntity.getName();
            allDSMetaEntityMpas.put(dsMetaEntityName, dSMetaEntity);
            List<DSMetaProperty> dsMetaProperties = dSMetaEntity.getProperties();
            HashMap<String, DSMetaProperty> dsMetaPropertyMap = new HashMap<String, DSMetaProperty>(dsMetaProperties.size(), 1.0f);
            for (DSMetaProperty dsMetaProperty : dsMetaProperties) {
                dsMetaPropertyMap.put(dsMetaProperty.getName(), dsMetaProperty);
            }
            allDSMetaPropertyMpas.put(dsMetaEntityName, dsMetaPropertyMap);
        }
        HashMap<String, DSMetaEntity> selectedEntitiesMap = new HashMap<String, DSMetaEntity>();
        for (DSFieldKey fieldKey : allSelectedFieldKeys) {
            DSMetaProperty dsMetaProperty;
            Map dsMetaPropertyMap;
            String entityName = fieldKey.getEntityName();
            DSMetaEntity dsMetaEntity = (DSMetaEntity)allDSMetaEntityMpas.get(entityName);
            if (dsMetaEntity == null) continue;
            DSMetaEntity entity = (DSMetaEntity)selectedEntitiesMap.get(entityName);
            if (entity == null) {
                entity = new DSMetaEntity(entityName, dsMetaEntity.getDisplayName());
                entity.setParentName(dsMetaEntity.getParentName());
                selectedEntitiesMap.put(entityName, entity);
            }
            if ((dsMetaPropertyMap = (Map)allDSMetaPropertyMpas.get(entityName)) == null || (dsMetaProperty = (DSMetaProperty)dsMetaPropertyMap.get(fieldKey.getPropertyName())) == null) continue;
            entity.getProperties().add(dsMetaProperty);
        }
        if (selectedEntitiesMap.size() <= 1) {
            return;
        }
        ERGraph eRGraph = new ERGraph(this.entities, this.relations);
        this.eliminations = ERGraphUtil.getElimination(eRGraph, selectedEntitiesMap, selectedMeasuresFieldKey);
    }
}

