/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.meta;

import com.kingdee.bos.qing.datasource.meta.DSElimination;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSParentChildDimension;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.view.AbstractDSViewItem;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaEntitySubView;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class MetaInfo {
    public static final String ROWID = "_ROWID_";
    private List<String> fieldNames = new ArrayList<String>();
    private List<String> fieldDisplayNames = new ArrayList<String>();
    private List<DataType> fieldDataTypes = new ArrayList<DataType>();
    private List<Boolean> fieldIsHides = new ArrayList<Boolean>();
    private List<DSElimination> eliminations = null;
    private List<DSMetaEntitySubView> subViews = null;
    private List<AbstractDSViewItem> viewItems = null;
    private List<DSParentChildDimension> dsParentChildDimensions = null;

    public MetaInfo() {
    }

    public MetaInfo(List<String> fieldNames, List<String> fieldDisplayNames, List<DataType> fieldDataTypes) {
        this.fieldNames = fieldNames;
        this.fieldDisplayNames = fieldDisplayNames;
        this.fieldDataTypes = fieldDataTypes;
    }

    public List<String> getFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    public void setFieldHide(int colIndex, boolean isHide) {
        this.fieldIsHides.set(colIndex, isHide);
    }

    public List<String> getFieldDisplayNames() {
        return Collections.unmodifiableList(this.fieldDisplayNames);
    }

    public List<DataType> getFieldDataTypes() {
        if (this.fieldDataTypes == null) {
            return null;
        }
        return Collections.unmodifiableList(this.fieldDataTypes);
    }

    public List<Boolean> getFieldIsHides() {
        if (this.fieldNames.size() > this.fieldIsHides.size()) {
            int startIndex = this.fieldIsHides.size();
            int endIndex = this.fieldNames.size();
            for (int i = startIndex; i < endIndex; ++i) {
                this.fieldIsHides.add(false);
            }
        }
        return Collections.unmodifiableList(this.fieldIsHides);
    }

    public void setFieldDataTypes(List<DataType> fieldDataTypes) {
        this.fieldDataTypes = fieldDataTypes;
    }

    public void addField(String fieldName, String fieldDisplayName, DataType dataType) {
        this.addField(fieldName, fieldDisplayName, dataType, false);
    }

    public void addField(String fieldName, String fieldDisplayName, DataType dataType, boolean fieldIsHide) {
        if (this.fieldNames.contains(fieldName)) {
            throw new IllegalArgumentException(fieldName + " fieldName repeated.");
        }
        this.fieldNames.add(fieldName == null ? "" : fieldName);
        this.fieldDisplayNames.add(fieldDisplayName == null ? "" : fieldDisplayName);
        this.fieldDataTypes.add(dataType == null ? DataType.STRING : dataType);
        this.fieldIsHides.add(fieldIsHide);
    }

    public int getSize() {
        return this.fieldNames.size();
    }

    public String getFieldName(int index) {
        return this.fieldNames.get(index);
    }

    public String getFieldDisplayName(int index) {
        return this.fieldDisplayNames.get(index);
    }

    public DataType getFieldDataType(int index) {
        return this.fieldDataTypes.get(index);
    }

    public boolean getFieldIsHides(int index) {
        if (this.fieldIsHides.size() <= index) {
            return false;
        }
        return this.fieldIsHides.get(index);
    }

    public int getFieldNameIndex(String findFieldName) {
        return this.fieldNames.indexOf(findFieldName);
    }

    public List<DSElimination> getEliminations() {
        return this.eliminations;
    }

    public void setEliminations(List<DSElimination> eliminations) {
        this.eliminations = eliminations;
    }

    public List<DSMetaEntitySubView> getSubViews() {
        return this.subViews;
    }

    public void setSubViews(List<DSMetaEntitySubView> subViews) {
        this.subViews = subViews;
    }

    public void addSubView(DSMetaEntitySubView subView) {
        if (null == this.subViews) {
            this.subViews = new ArrayList<DSMetaEntitySubView>();
        }
        this.subViews.add(subView);
    }

    public List<AbstractDSViewItem> getViewItems() {
        return this.viewItems;
    }

    public void setViewItems(List<AbstractDSViewItem> viewItems) {
        this.viewItems = viewItems;
    }

    public List<DSParentChildDimension> getDsParentChildDimensions() {
        return this.dsParentChildDimensions;
    }

    public void setDsParentChildDimensions(List<DSParentChildDimension> dsParentChildDimensions) {
        this.dsParentChildDimensions = dsParentChildDimensions;
    }

    public MetaInfo initSelectedField(List<Integer> interestingFieldIndexs, List<String> allFullFieldNames, Set<DSFieldKey> fields, DSFieldKey rowidFieldKey, String cacheKey) {
        boolean checkOutputEntityName = false;
        String outputEntityName = null;
        interestingFieldIndexs.clear();
        boolean hasROWID = false;
        if (cacheKey != null && !cacheKey.isEmpty()) {
            Iterator<DSFieldKey> it = fields.iterator();
            if (it.hasNext()) {
                DSFieldKey field = it.next();
                if (outputEntityName == null) {
                    outputEntityName = field.getEntityName();
                }
            }
            for (int index = 0; index < this.fieldNames.size(); ++index) {
                interestingFieldIndexs.add(index);
                String fieldName = this.fieldNames.get(index);
                String fieldFullName = NameUtil.encodeFullName(outputEntityName, fieldName);
                allFullFieldNames.add(fieldFullName);
            }
        } else {
            String fieldName;
            HashSet<DSFieldKey> selectFields = new HashSet<DSFieldKey>();
            selectFields.addAll(fields);
            Iterator selectFieldIterator = selectFields.iterator();
            while (selectFieldIterator.hasNext()) {
                int idx;
                DSFieldKey selectField = (DSFieldKey)selectFieldIterator.next();
                if (!checkOutputEntityName && outputEntityName == null) {
                    outputEntityName = selectField.getEntityName();
                    checkOutputEntityName = true;
                }
                if ((fieldName = selectField.getPropertyName()).equals(ROWID)) {
                    hasROWID = true;
                }
                if ((idx = this.fieldNames.indexOf(fieldName)) >= 0) {
                    interestingFieldIndexs.add(idx);
                    continue;
                }
                selectFieldIterator.remove();
            }
            for (int index = 0; index < this.fieldNames.size(); ++index) {
                fieldName = this.fieldNames.get(index);
                String fieldFullName = NameUtil.encodeFullName(outputEntityName, fieldName);
                allFullFieldNames.add(fieldFullName);
            }
        }
        MetaInfo itertorMetaInfo = new MetaInfo();
        if (interestingFieldIndexs.size() > 0) {
            for (int index = 0; index < interestingFieldIndexs.size(); ++index) {
                int fieldIndex = interestingFieldIndexs.get(index);
                itertorMetaInfo.addField(allFullFieldNames.get(fieldIndex), this.getFieldDisplayName(fieldIndex), this.getFieldDataType(fieldIndex), this.getFieldIsHides(fieldIndex));
            }
        }
        if (hasROWID) {
            String fieldFullName = NameUtil.encodeFullName(outputEntityName, ROWID);
            itertorMetaInfo.addField(fieldFullName, ROWID, DataType.INT, true);
            rowidFieldKey.setEntityName(outputEntityName);
        }
        Collections.sort(interestingFieldIndexs);
        return itertorMetaInfo;
    }
}

