/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ConvertUtil {
    protected static final long TIME_IN_MILLIS_19000101 = -2209017600000L;
    protected static final long TIME_IN_MILLIS_OF_DAY = 86400000L;
    private static final boolean[][] COMPATIBILITY = new boolean[][]{{true, true, true, true, true}, {true, true, true, true, true}, {true, false, true, true, false}, {true, false, false, true, false}, {true, false, false, false, true}};

    public static boolean isDataTypeCompatible(int expected, int real) {
        return COMPATIBILITY[expected][real];
    }

    public static String convertToString(Object value) {
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Calendar) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((Calendar)value).getTime());
        }
        if (value instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)value);
        }
        if (value instanceof Boolean) {
            return Boolean.toString((Boolean)value);
        }
        return "";
    }

    public static BigDecimal convertToNumber(Object value) throws NumberFormatException {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString());
        }
        if (value instanceof Calendar) {
            double millis = ((Calendar)value).getTimeInMillis() - -2209017600000L;
            double days = millis / 8.64E7 + 1.0;
            return BigDecimal.valueOf(days);
        }
        if (value instanceof Date) {
            double millis = ((Date)value).getTime() - -2209017600000L;
            double days = millis / 8.64E7 + 1.0;
            return BigDecimal.valueOf(days);
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        return null;
    }

    public static Calendar convertToDate(Object value) {
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            return calendar;
        }
        if (value instanceof Long) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis((Long)value);
            return calendar;
        }
        return null;
    }

    public static Boolean convertToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }
}

