/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.util;

import com.kingdee.bos.qing.datasource.model.filter.UnderDSDiscreteFilter;
import java.util.Calendar;

public class DateUtil {
    public static String getPartValue(UnderDSDiscreteFilter.PartValue partValue, Calendar calendar, int fiscalYearStart) {
        if (calendar == null) {
            return null;
        }
        switch (partValue) {
            case DATE_YEAR: {
                return DateUtil.getFiscalableYear(calendar, fiscalYearStart);
            }
            case DATE_YQ: {
                return DateUtil.getFiscalableYQ(calendar, fiscalYearStart);
            }
            case DATE_QUARTER: {
                return DateUtil.getFiscalableQuarter(calendar, fiscalYearStart);
            }
            case DATE_MONTH: {
                return DateUtil.getFiscalableMonth(calendar, fiscalYearStart);
            }
            case DATE_DAY: {
                return DateUtil.getDayAtMonth(calendar);
            }
            case DATE_YM: {
                return DateUtil.getYM(calendar);
            }
            case DATE_YMD: {
                return DateUtil.getYMD(calendar);
            }
        }
        throw new RuntimeException("Something must be wrong.");
    }

    private static String getDayAtMonth(Calendar calendar) {
        return calendar.get(5) + "";
    }

    private static String getYM(Calendar calendar) {
        return calendar.get(1) * 100 + calendar.get(2) + "";
    }

    private static String getYMD(Calendar calendar) {
        return calendar.get(1) * 10000 + calendar.get(2) * 100 + calendar.get(5) + "";
    }

    private static String getFiscalableMonth(Calendar calendar, int fiscalYearStart) {
        int year = 2016;
        if (fiscalYearStart > 1 && calendar.get(2) + 1 >= fiscalYearStart) {
            --year;
        }
        Calendar inst = Calendar.getInstance();
        inst.set(year, calendar.get(2), 1, 0, 0, 0);
        inst.set(14, 0);
        return inst.get(2) + "";
    }

    private static String getFiscalableYear(Calendar calendar, int fiscalYearStart) {
        int year = calendar.get(1);
        if (fiscalYearStart > 1 && calendar.get(2) + 1 >= fiscalYearStart) {
            return year + 1 + "";
        }
        return year + "";
    }

    private static String getFiscalableQuarter(Calendar calendar, int fiscalYearStart) {
        int month = calendar.get(2) + 1;
        int monthAtFY = fiscalYearStart > 1 ? (month - fiscalYearStart + 12) % 12 + 1 : month;
        return (int)Math.floor((monthAtFY - 1) / 3) + 1 + "";
    }

    private static String getFiscalableYQ(Calendar calendar, int fiscalYearStart) {
        int year = calendar.get(1);
        if (fiscalYearStart > 1 && calendar.get(2) + 1 >= fiscalYearStart) {
            ++year;
        }
        int month = calendar.get(2) + 1;
        int monthAtFY = fiscalYearStart > 1 ? (month - fiscalYearStart + 12) % 12 + 1 : month;
        monthAtFY = (int)Math.floor((monthAtFY - 1) / 3) + 1;
        return year * 10000 + monthAtFY + "";
    }
}

