/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain.progress;

import com.kingdee.bos.qing.common.framework.api.RemoteFrameworkHelper;

public class ProcessingFeedback {
    private static ThreadLocal<IProcessingFeedbackHandler> threadLocal = new ThreadLocal();

    public static void initDefaultHandler() {
        ProcessingFeedback.setHandler(new DefaultProcessingFeedbackHandler());
    }

    private static void setHandler(IProcessingFeedbackHandler handler) {
        threadLocal.set(handler);
    }

    public static boolean isHandlerExist() {
        return threadLocal.get() != null;
    }

    public static void sendProgress(IProgress progress) {
        IProcessingFeedbackHandler handler = threadLocal.get();
        if (handler != null) {
            handler.sendProgress(progress);
        }
    }

    public static boolean isStoppedByEnv() {
        IProcessingFeedbackHandler handler = threadLocal.get();
        return handler != null && handler.checkUserStopped();
    }

    public static class DefaultProgress
    implements IProgress {
        private int percent;

        public void setPercentage(int percent) {
            this.percent = percent;
        }

        public int getPercentage() {
            return this.percent;
        }
    }

    public static interface IProgress {
    }

    private static class DefaultProcessingFeedbackHandler
    implements IProcessingFeedbackHandler {
        private DefaultProcessingFeedbackHandler() {
        }

        @Override
        public void sendProgress(IProgress progress) {
            RemoteFrameworkHelper.sendProgress(progress);
        }

        @Override
        public boolean checkUserStopped() {
            try {
                RemoteFrameworkHelper.checkUserStopped();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return true;
            }
            return false;
        }
    }

    public static interface IProcessingFeedbackHandler {
        public void sendProgress(IProgress var1);

        public boolean checkUserStopped();
    }
}

