/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager;

import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.QingFileWriterWraper;
import com.kingdee.bos.qing.filesystem.manager.api.IFileResourceService;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.filesystem.stream.QingOutputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;

public abstract class AbstractQingFile
implements IQingFile {
    protected IFileResourceService _fileResourceService;
    protected QingFileResourceInfo _fileResourceInfo;
    protected AbstractQingFileType _fileType;
    private String _name;

    public AbstractQingFile(AbstractQingFileType fileType) {
        this._fileType = fileType;
        this._name = UUID.randomUUID().toString();
    }

    protected AbstractQingFile(AbstractQingFileType fileType, String name) {
        this._fileType = fileType;
        this._name = name;
    }

    @Override
    public final IFileResourceService getFileResourceService() {
        return this._fileResourceService;
    }

    @Override
    public final void setFileResourceService(IFileResourceService fileResourceService) {
        this._fileResourceService = fileResourceService;
    }

    @Override
    public final void setFileResourceInfo(QingFileResourceInfo fileResourceInfo) {
        this._fileResourceInfo = fileResourceInfo;
    }

    protected final String getPath() {
        return this.getPath(this._fileType, this._name);
    }

    protected final String getPath(String name) {
        return this.getPath(this._fileType, name);
    }

    protected final String getPath(AbstractQingFileType fileType, String name) {
        return fileType.getSubFolder() + File.separator + name;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final AbstractQingFileType getFileType() {
        return this._fileType;
    }

    public final int getFileTypeIndex() {
        return this._fileType.getTypeIndex();
    }

    @Override
    public final IQingFileWriter createWriter() {
        return new QingFileWriterWraper(this._fileResourceService, this._fileResourceInfo, this, this.doCreateWriter());
    }

    @Override
    public final boolean createNewFile() throws IOException {
        if (this.doCreateNewFile()) {
            if (this._fileResourceService != null) {
                QingFileInfo fileInfo = new QingFileInfo();
                fileInfo.setName(this.getName());
                fileInfo.setFileType(this.getFileType());
                fileInfo.setFileSize(0L);
                fileInfo.setCreateDate(new Date());
                try {
                    this._fileResourceService.saveFile(fileInfo, this._fileResourceInfo);
                }
                catch (Exception e) {
                    this.doDelete();
                    throw new IOException(e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean delete() {
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug("delete file :" + this.getPath());
        }
        if (this._fileResourceService != null) {
            try {
                this._fileResourceService.deleteFile(this._fileType, this._name);
            }
            catch (Exception e) {
                LogUtil.error("delete file resource error.", e);
            }
        }
        return this.doDelete();
    }

    @Override
    public final boolean deleteIgnoreUserId() {
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug("delete file :" + this.getPath());
        }
        if (this._fileResourceService != null) {
            try {
                this._fileResourceService.deleteFileIgnoreUserId(this._fileType, this._name);
            }
            catch (Exception e) {
                LogUtil.error("delete file resource error.", e);
            }
        }
        return this.doDelete();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void write(IWriteCall writeCall, boolean autoDeleteIfFailed) throws IOException {
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug("write file :" + this.getPath());
        }
        IQingFileWriter writer = null;
        QingOutputStream outputStream = null;
        Exception exception = null;
        try {
            writer = this.createWriter();
            outputStream = writer.getOutputStream();
            writeCall.call(outputStream);
        }
        catch (IOException e) {
            try {
                exception = e;
                throw e;
                catch (RuntimeException e2) {
                    exception = e2;
                    throw new IOException(e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close(outputStream);
                if (writer == null) throw throwable;
                writer.close(exception);
                writer = null;
                if (!autoDeleteIfFailed) throw throwable;
                if (exception == null) throw throwable;
                this.delete();
                throw throwable;
            }
        }
        CloseUtil.close(outputStream);
        if (writer == null) return;
        writer.close(exception);
        writer = null;
        if (!autoDeleteIfFailed) return;
        if (exception == null) return;
        this.delete();
    }

    protected abstract IQingFileWriter doCreateWriter();

    protected abstract boolean doCreateNewFile() throws IOException;

    protected abstract boolean doDelete();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(IQingFile qingFile, boolean autoDeleteIfFailed) throws IOException {
        QingInputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            qingFile.write(new CopyWriteCall(inputStream, false), autoDeleteIfFailed);
        }
        catch (Throwable throwable) {
            CloseUtil.close(inputStream);
            inputStream = null;
            throw throwable;
        }
        CloseUtil.close(inputStream);
        inputStream = null;
    }
}

