/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.fileresource.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.integrated.IIntegratedHelperStrategy;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourcePO;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FileResourceDao {
    private IDBExcuter dbExcuter;

    public FileResourceDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public BigDecimal findSumFileSizeByUserId(String userId) throws AbstractQingIntegratedException, SQLException {
        return this.dbExcuter.query("SELECT SUM(FFILESIZE) as SUMFILESIZE FROM T_QING_FILE_RESOURCE WHERE FUSERID=?", new Object[]{userId}, new ResultHandler<BigDecimal>(){

            @Override
            public BigDecimal handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    if (rs.getBigDecimal("SUMFILESIZE") == null) {
                        return new BigDecimal(0);
                    }
                    return rs.getBigDecimal("SUMFILESIZE");
                }
                return new BigDecimal(0);
            }
        });
    }

    public BigDecimal findSumTenantUseFileSizeByTenantId(String tenantId, long userFreeFileSizeByte) throws AbstractQingIntegratedException, SQLException {
        return this.dbExcuter.query("SELECT SUM(a.userFileSumSize) as SUMFILESIZE  FROM ( SELECT (sum(FFILESIZE)-?) as userFileSumSize FROM T_QING_FILE_RESOURCE WHERE FTENANTID=? group by FUSERID) a where a.userFileSumSize>0", new Object[]{userFreeFileSizeByte, tenantId}, new ResultHandler<BigDecimal>(){

            @Override
            public BigDecimal handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    if (rs.getBigDecimal("SUMFILESIZE") == null) {
                        return new BigDecimal(0);
                    }
                    return rs.getBigDecimal("SUMFILESIZE");
                }
                return new BigDecimal(0);
            }
        });
    }

    public void insert(FileResourcePO resourceFile) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_FILE_RESOURCE (FID, FTENANTID, FUSERID, FFROMID, FFROMTYPE, FFILETYPESUBFOLDER, FDISPLAYNAME, FFILENAME, FFILESIZE, FCREATEDATE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        Object[] params = new Object[10];
        String id = this.dbExcuter.genStringId("T_QING_FILE_RESOURCE");
        params[0] = id;
        params[1] = resourceFile.getTenantId();
        params[2] = resourceFile.getUserId();
        params[3] = resourceFile.getFromId();
        params[4] = resourceFile.getFromType().name();
        params[5] = resourceFile.getFileTypeSubFolder();
        params[6] = resourceFile.getDisplayName();
        params[7] = resourceFile.getFileName();
        params[8] = resourceFile.getFileSize();
        params[9] = resourceFile.getCreateDate();
        this.dbExcuter.execute(sql, params);
    }

    public List<FileResourceVO> findResourceFileListByUserId(String userId, String sortField, String sortOrder) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT fr.FFROMID, fr.FDISPLAYNAME, fr.FFROMTYPE, fr.FCREATEDATE, fr.FFILESIZE, ISNULL (t.FNAME, p.FNAME) as FROMNAME FROM T_QING_FILE_RESOURCE fr LEFT JOIN t_qing_theme t ON fr.FFROMID=t.FID LEFT JOIN t_qing_publish p ON fr.FFROMID=p.FID WHERE fr.FUSERID =?";
        sql = "displayName".equals(sortField) ? sql + " ORDER BY fr.FDISPLAYNAME " + sortOrder : ("fromName".equals(sortField) ? sql + " ORDER BY FROMNAME " + sortOrder : ("fromType".equals(sortField) ? sql + " ORDER BY fr.FFROMTYPE " + sortOrder : ("fileSize".equals(sortField) ? sql + " ORDER BY fr.FFILESIZE " + sortOrder : ("createDate".equals(sortField) ? sql + " ORDER BY fr.FCREATEDATE " + sortOrder : sql + " ORDER BY fr.FFILESIZE DESC"))));
        List<FileResourceVO> list = this.dbExcuter.query(sql, new Object[]{userId}, new ResultHandler<List<FileResourceVO>>(){

            @Override
            public List<FileResourceVO> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper = CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<FileResourceVO> list = new ArrayList<FileResourceVO>(10);
                while (rs.next()) {
                    FileResourceVO resourceFile = new FileResourceVO();
                    resourceFile.setFromId(rs.getString("FFROMID"));
                    resourceFile.setFromName(rs.getString("FROMNAME"));
                    resourceFile.setDisplayName(rs.getString("FDISPLAYNAME"));
                    resourceFile.setFromType(rs.getString("FFROMTYPE"));
                    resourceFile.setFileSize(rs.getString("FFILESIZE"));
                    long fcreatedate = rs.getTimestamp("FCREATEDATE").getTime();
                    resourceFile.setCreateDate(fcreatedate);
                    String formatDateTime = IntegratedHelper.formatDateTime(new Date(fcreatedate));
                    resourceFile.setCreateDateFormat(formatDateTime);
                    list.add(resourceFile);
                }
                return list;
            }
        });
        return list;
    }

    public List<FileResourcePO> findFileListByUserIdAndFromId(String userId, String formId) throws AbstractQingIntegratedException, SQLException {
        List<FileResourcePO> list = this.dbExcuter.query("SELECT FFILENAME, FFILETYPESUBFOLDER FROM T_QING_FILE_RESOURCE WHERE FUSERID=? AND FFROMID=?", new Object[]{userId, formId}, new ResultHandler<List<FileResourcePO>>(){

            @Override
            public List<FileResourcePO> handle(ResultSet rs) throws SQLException {
                ArrayList<FileResourcePO> list = new ArrayList<FileResourcePO>(10);
                while (rs.next()) {
                    FileResourcePO resourceFile = new FileResourcePO();
                    resourceFile.setFileName(rs.getString("FFILENAME"));
                    resourceFile.setFileTypeSubFolder(rs.getString("FFILETYPESUBFOLDER"));
                    list.add(resourceFile);
                }
                return list;
            }
        });
        return list;
    }

    public void deleteFileByUserIdAndFromId(String userId, String formId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_FILE_RESOURCE WHERE FUSERID=? AND FFROMID=?";
        this.dbExcuter.execute(sql, new Object[]{userId, formId});
    }

    public void deleteFileByFileTypeSubFolderAndFileName(String userId, String fileTypeSubFolder, String fileName) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_FILE_RESOURCE WHERE FUSERID=? AND FFILETYPESUBFOLDER=? AND FFILENAME=?";
        this.dbExcuter.execute(sql, new Object[]{userId, fileTypeSubFolder, fileName});
    }

    public void deleteFileByFileTypeSubFolderAndFileName(String fileTypeSubFolder, String fileName) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_FILE_RESOURCE WHERE FFILETYPESUBFOLDER=? AND FFILENAME=?";
        this.dbExcuter.execute(sql, new Object[]{fileTypeSubFolder, fileName});
    }

    public Integer getFileResourceCountByUserIdAndFileName(String userId, String fileUrl) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT COUNT(1) AS COUNT_FILE_RESOURCE FROM T_QING_FILE_RESOURCE FR WHERE FR.FUSERID = ? AND FFILENAME = ?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        queryValue.add(fileUrl);
        return this.dbExcuter.query(sql, queryValue.toArray(), new ResultHandler<Integer>(){

            @Override
            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("count_file_resource");
                }
                return 0;
            }
        });
    }
}

