/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.msgbus.sort;

import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.msgbus.model.msgpack.MsgPackToDeliver;
import com.kingdee.bos.qing.msgbus.model.msgpack.MsgPackage;
import com.kingdee.bos.qing.msgbus.model.node.Node;
import com.kingdee.bos.qing.msgbus.sort.NodeFactory;
import java.util.ArrayList;
import java.util.List;

public class MsgSorter {
    private String sessionId;

    public MsgSorter(String sessionId) {
        this.sessionId = sessionId;
    }

    public List<MsgPackToDeliver> sortMsgPack(String msgPackId) {
        ArrayList<MsgPackToDeliver> msgPacks = new ArrayList<MsgPackToDeliver>(10);
        IQingSession session = QingSessionUtil.getQingSession(this.sessionId);
        if (session == null) {
            return msgPacks;
        }
        MsgPackage msgPackage = session.getCache(msgPackId, MsgPackage.class);
        if (msgPackage == null) {
            return msgPacks;
        }
        List<String> receiverNodeIds = msgPackage.getReceiverIds();
        for (String receiverNodeId : receiverNodeIds) {
            Node node = NodeFactory.createNode(receiverNodeId);
            if (node == null) continue;
            MsgPackToDeliver msgPackToDeliver = new MsgPackToDeliver();
            msgPackToDeliver.setMessage(msgPackage.getMessage());
            msgPackToDeliver.setReceiver(node);
            msgPacks.add(msgPackToDeliver);
        }
        session.remove(msgPackId);
        return msgPacks;
    }
}

