/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule.dao.impl;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.integrated.IIntegratedHelperStrategy;
import com.kingdee.bos.qing.schedule.dao.IScheduleExecuteDao;
import com.kingdee.bos.qing.schedule.model.AppTypeEnum;
import com.kingdee.bos.qing.schedule.model.ExecuteStateEnum;
import com.kingdee.bos.qing.schedule.model.ScheduleExecutePO;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ScheduleExecuteDaoImpl
implements IScheduleExecuteDao {
    private IDBExcuter dbExcuter;

    public ScheduleExecuteDaoImpl(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    @Override
    public int getExecuteCountByUserId(String userId, Date dateMin, Date dateMax, AppTypeEnum appTypeEnum) throws AbstractQingIntegratedException, SQLException {
        return this.dbExcuter.query("SELECT count(*) as FEXECUTECOUNT FROM T_QING_Schedule_Execute WHERE FEXECUTESTATE IN (0, 1, 3, 4, 5, 6) AND FUSERID=? AND FEXECUTETIME>=? AND FEXECUTETIME<=? AND FAPPTYPE=?", new Object[]{userId, dateMin, dateMax, appTypeEnum.getAppType()}, new ResultHandler<Integer>(){

            @Override
            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("FEXECUTECOUNT");
                }
                return 0;
            }
        });
    }

    @Override
    public int getExecuteCountByTenantId(String tenantId, int userFreeScheduleCount, Date dateMin, Date dateMax, AppTypeEnum appTypeEnum) throws AbstractQingIntegratedException, SQLException {
        return this.dbExcuter.query("SELECT SUM(a.sumCount) as SUMTENANTCOUNT FROM ( SELECT (count(*)-?) as sumCount FROM T_QING_Schedule_Execute WHERE FEXECUTESTATE IN (0, 1, 3, 4, 5, 6) AND FTENANTID=? AND FEXECUTETIME>=? AND FEXECUTETIME<=? AND FAPPTYPE=? group by FUSERID) a where a.sumCount>0", new Object[]{userFreeScheduleCount, tenantId, dateMin, dateMax, appTypeEnum.getAppType()}, new ResultHandler<Integer>(){

            @Override
            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("SUMTENANTCOUNT");
                }
                return 0;
            }
        });
    }

    @Override
    public List<ScheduleExecuteVO> findScheduleExecuteListByUserId(String userId, Date timeMin, Date timeMax) throws AbstractQingIntegratedException, SQLException {
        List<ScheduleExecuteVO> list = this.dbExcuter.query("SELECT se.FID, se.FSCHEDULENAME, se.FSOURCEID, se.FSOURCENAME, se.FEXECUTESTATE, se.FEXECUTETIME, se.FENDTIME,  t.FNAME as FTHEMENAME, p.FNAME as FPUBLISHNAME FROM T_QING_Schedule_Execute se LEFT JOIN t_qing_theme t ON se.FSOURCEID=t.FID LEFT JOIN t_qing_publish p ON se.FSOURCEID=p.FID WHERE se.FUSERID=? AND se.FEXECUTETIME>=? AND se.FEXECUTETIME<=? ORDER BY se.FEXECUTETIME DESC", new Object[]{userId, timeMin, timeMax}, new ResultHandler<List<ScheduleExecuteVO>>(){

            @Override
            public List<ScheduleExecuteVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ScheduleExecuteVO> list = new ArrayList<ScheduleExecuteVO>(10);
                while (rs.next()) {
                    ScheduleExecuteVO scheduleExecute = new ScheduleExecuteVO();
                    ScheduleExecuteDaoImpl.this.createScheduleExecuteVo(rs, scheduleExecute);
                    list.add(scheduleExecute);
                }
                return list;
            }
        });
        return list;
    }

    private void createScheduleExecuteVo(ResultSet rs, ScheduleExecuteVO scheduleExecute) throws SQLException {
        scheduleExecute.setId(rs.getString("FID"));
        scheduleExecute.setScheduleName(rs.getString("FSCHEDULENAME"));
        scheduleExecute.setSourceId(rs.getString("FSOURCEID"));
        String sourceName = "";
        String themeName = rs.getString("FTHEMENAME");
        String publishName = rs.getString("FPUBLISHNAME");
        if (themeName != null && !"".equals(themeName)) {
            sourceName = themeName;
        }
        if (publishName != null && !"".equals(publishName)) {
            sourceName = publishName;
        }
        if ("".equals(sourceName) && rs.getString("FSOURCENAME") != null) {
            sourceName = rs.getString("FSOURCENAME");
        }
        scheduleExecute.setSourceName(sourceName);
        scheduleExecute.setExecuteState(rs.getInt("FEXECUTESTATE"));
        IIntegratedHelperStrategy IntegratedHelper = CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
        long fexecutetime = rs.getTimestamp("FEXECUTETIME").getTime();
        scheduleExecute.setExecuteTime(fexecutetime);
        String executeTimeFormat = IntegratedHelper.formatDateTime(new Date(fexecutetime));
        scheduleExecute.setExecuteTimeFormat(executeTimeFormat);
        if (rs.getTimestamp("FENDTIME") != null) {
            long fendtime = rs.getTimestamp("FENDTIME").getTime();
            scheduleExecute.setEndTime(fendtime);
            String endTimeFormat = IntegratedHelper.formatDateTime(new Date(fendtime));
            scheduleExecute.setEndTimeFormat(endTimeFormat);
        }
    }

    @Override
    public ScheduleExecuteVO findScheduleExecuteById(String id) throws AbstractQingIntegratedException, SQLException {
        ScheduleExecuteVO scheduleExecuteVO = this.dbExcuter.query("SELECT FID,FTENANTID,FUSERID,FSCHEDULENAME,FSOURCEID,FSOURCENAME,FEXECUTESTATE,FMSG,FEXECUTETIME, FENDTIME, FMETHODNAME FROM T_QING_SCHEDULE_EXECUTE WHERE FID=?", new Object[]{id}, new ResultHandler<ScheduleExecuteVO>(){

            @Override
            public ScheduleExecuteVO handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper = CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ScheduleExecuteVO scheduleExecuteVO = new ScheduleExecuteVO();
                if (rs.next()) {
                    scheduleExecuteVO.setId(rs.getString("FID"));
                    scheduleExecuteVO.setScheduleName(rs.getString("FSCHEDULENAME"));
                    scheduleExecuteVO.setSourceId(rs.getString("FSOURCEID"));
                    scheduleExecuteVO.setMethodName(rs.getString("FMETHODNAME"));
                    scheduleExecuteVO.setExecuteState(rs.getInt("FEXECUTESTATE"));
                    long fexecutetime = rs.getTimestamp("FEXECUTETIME").getTime();
                    scheduleExecuteVO.setExecuteTime(fexecutetime);
                    String executeTimeFormat = IntegratedHelper.formatDateTime(new Date(fexecutetime));
                    scheduleExecuteVO.setExecuteTimeFormat(executeTimeFormat);
                    if (rs.getTimestamp("FENDTIME") != null) {
                        long fendtime = rs.getTimestamp("FENDTIME").getTime();
                        scheduleExecuteVO.setEndTime(fendtime);
                        String endTimeFormat = IntegratedHelper.formatDateTime(new Date(fendtime));
                        scheduleExecuteVO.setEndTimeFormat(endTimeFormat);
                    }
                }
                return scheduleExecuteVO;
            }
        });
        return scheduleExecuteVO;
    }

    @Override
    public String insert(ScheduleExecutePO scheduleExecutePO) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_Schedule_Execute (FID, FTENANTID, FUSERID, FSCHEDULENAME, FSOURCEID, FSOURCENAME, FMETHODNAME, FEXECUTESTATE, FEXECUTETIME, FAPPTYPE) VALUES (?,?,?,?,?,?,?,?,?,?)";
        Object[] params = new Object[10];
        String id = this.dbExcuter.genStringId("T_QING_Schedule_Execute");
        params[0] = id;
        params[1] = scheduleExecutePO.getTenantId();
        params[2] = scheduleExecutePO.getUserId();
        params[3] = scheduleExecutePO.getScheduleName();
        params[4] = scheduleExecutePO.getSourceId();
        params[5] = scheduleExecutePO.getSourceName();
        params[6] = scheduleExecutePO.getScheduleExecuterNameEnum();
        params[7] = scheduleExecutePO.getExecuteStateEnum().getState();
        params[8] = new Date();
        params[9] = scheduleExecutePO.getAppTypeEnum().getAppType();
        this.dbExcuter.execute(sql, params);
        return id;
    }

    @Override
    public int findPaySizeByTenantId(String tenantId) throws AbstractQingIntegratedException, SQLException {
        return this.dbExcuter.query("SELECT FSIZE FROM T_QING_Res_Tenant_Manage WHERE FTENANTID=? AND FTYPE=2", new Object[]{tenantId}, new ResultHandler<Integer>(){

            @Override
            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("FSIZE");
                }
                return 0;
            }
        });
    }

    @Override
    public void updateExecuteState(String id, ExecuteStateEnum executeStateEnum) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_Schedule_Execute SET FEXECUTESTATE=?, FENDTIME=? WHERE FID=?";
        Object[] params = new Object[]{executeStateEnum.getState(), executeStateEnum == ExecuteStateEnum.EXECUTING ? null : new Date(), id};
        this.dbExcuter.execute(sql, params);
    }

    @Override
    public void deleteScheduleExecuteListByExecuteTime(Date executeTime) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{executeTime};
        this.dbExcuter.execute("DELETE FROM T_QING_SCHEDULE_EXECUTE WHERE FEXECUTETIME < ?", params);
    }
}

