/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.schedule.domain.IScheduleExecuteDomain;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class ScheduleExecuteDomainFactory {
    private static Map<String, Constructor<? extends IScheduleExecuteDomain>> SCHEDULE_EXECUTE_DOMAIN_CLASS_MAP = new HashMap<String, Constructor<? extends IScheduleExecuteDomain>>();

    public static IScheduleExecuteDomain createDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx, String methodName) {
        Constructor<? extends IScheduleExecuteDomain> constructor = SCHEDULE_EXECUTE_DOMAIN_CLASS_MAP.get(methodName);
        if (constructor == null) {
            return null;
        }
        try {
            return constructor.newInstance(qingContext, dbExcuter, tx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void regist(String methodName, Class<? extends IScheduleExecuteDomain> clazz) {
        try {
            Constructor<? extends IScheduleExecuteDomain> constructor = clazz.getConstructor(QingContext.class, IDBExcuter.class, ITransactionManagement.class);
            SCHEDULE_EXECUTE_DOMAIN_CLASS_MAP.put(methodName, constructor);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

