/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class IOUtil {
    private static final int BUFFER_SIZE = 32768;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File[] subs, String baseName, ZipOutputStream zos) throws IOException {
        for (int i = 0; i < subs.length; ++i) {
            File f = subs[i];
            if (f == null || !f.exists() || !f.isFile()) continue;
            FileInputStream fis = null;
            try {
                zos.putNextEntry(new ZipEntry(baseName + f.getName()));
                fis = new FileInputStream(f);
                byte[] buffer = new byte[1024];
                int r = 0;
                while ((r = fis.read(buffer)) != -1) {
                    zos.write(buffer, 0, r);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close(fis);
                throw throwable;
            }
            CloseUtil.close(fis);
        }
    }

    public static void copyFile(String from, String to) throws IOException {
        File fromFile = new File(from);
        File toFile = new File(to);
        File parent = toFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        IOUtil.copyFile(fromFile, toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileChannel in = null;
        FileChannel out = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(from);
            fos = new FileOutputStream(to);
            in = fis.getChannel();
            out = fos.getChannel();
            in.transferTo(0L, in.size(), out);
        }
        catch (Throwable throwable) {
            CloseUtil.close(fos, fis, in, out);
            throw throwable;
        }
        CloseUtil.close(fos, fis, in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream in, File to) throws IOException {
        InputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = in;
            fos = new FileOutputStream(to);
            IOUtil.copy(fis, fos);
        }
        catch (Throwable throwable) {
            CloseUtil.close(fos, fis);
            throw throwable;
        }
        CloseUtil.close(fos, fis);
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int size = 0;
        byte[] block = new byte[32768];
        int r = 0;
        while ((r = in.read(block)) != -1) {
            out.write(block, 0, r);
            size += r;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeZipEntry(ZipOutputStream zos, AbstractQingFileType fileType, String name, String zipEntryPath) throws IOException {
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor(fileType, name);
        if (fileVisitor != null && fileVisitor.exists()) {
            zos.putNextEntry(new ZipEntry(zipEntryPath));
            QingInputStream in = null;
            try {
                in = fileVisitor.getInputStream();
                IOUtil.copy(in, zos);
            }
            catch (Throwable throwable) {
                CloseUtil.close(in);
                throw throwable;
            }
            CloseUtil.close(in);
        }
    }

    public static boolean saveFile(byte[] bytes, String disPath) throws IOException {
        File parentFile;
        File outputFile = new File(disPath);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        if (!(parentFile = outputFile.getParentFile()).exists()) {
            parentFile.mkdirs();
        }
        IOException ioException = null;
        BufferedOutputStream outputFileStream = null;
        try {
            outputFileStream = new BufferedOutputStream(new FileOutputStream(outputFile));
            ((OutputStream)outputFileStream).write(bytes);
        }
        catch (IOException e) {
            try {
                ioException = e;
                throw e;
            }
            catch (Throwable throwable) {
                CloseUtil.close(outputFileStream);
                if (ioException != null) {
                    outputFile.delete();
                }
                throw throwable;
            }
        }
        CloseUtil.close(outputFileStream);
        if (ioException != null) {
            outputFile.delete();
        }
        return true;
    }
}

