/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetUtil {
    private static String LOCALIP = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String getIp() {
        if (LOCALIP != null) return LOCALIP;
        Class<NetUtil> clazz = NetUtil.class;
        synchronized (NetUtil.class) {
            if (LOCALIP != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return LOCALIP;
            }
            try {
                Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
                InetAddress ip = null;
                block5: while (allNetInterfaces.hasMoreElements()) {
                    NetworkInterface netInterface = allNetInterfaces.nextElement();
                    Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        ip = addresses.nextElement();
                        if (!(ip instanceof Inet4Address) || ip.getHostAddress().equals("127.0.0.1")) continue;
                        LOCALIP = ip.getHostAddress();
                        continue block5;
                    }
                }
            }
            catch (SocketException e) {
                throw new RuntimeException("get LocalHost ip failed.", e);
            }
            return LOCALIP;
        }
    }

    public static String getLocalHostIp() {
        try {
            String localIp = InetAddress.getLocalHost().getHostAddress();
            if (localIp.equals("127.0.0.1")) {
                return NetUtil.getIp();
            }
            return localIp;
        }
        catch (UnknownHostException e) {
            LogUtil.error("", e);
            return null;
        }
    }

    public static String getValidLocalIp() {
        String localIp = SystemPropertyUtil.getString("java.rmi.server.hostname");
        if (StringUtils.isEmpty(localIp)) {
            localIp = NetUtil.getLocalHostIp();
        }
        return localIp;
    }

    public static boolean isLoopOrNullIp(String ip) {
        return null == ip || "127.0.0.1".equals(ip);
    }
}

