/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.common;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkURLClassLoader
extends ClassLoader {
    private final URL codebaseURL;

    public NetworkURLClassLoader(String codebase) throws MalformedURLException {
        this.codebaseURL = new URL(codebase);
    }

    @Override
    protected URL findResource(String name) {
        try {
            return new URL(this.codebaseURL, name);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Exception exception = null;
        int i = 0;
        while (i < 2) {
            String path = String.valueOf(name.replace('.', '/')) + ".class";
            URL resourceURL = this.getResource(path);
            InputStream in = null;
            Class<?> clazz = null;
            exception = null;
            try {
                int n;
                URLConnection connection = resourceURL.openConnection();
                connection.setReadTimeout(4000);
                in = connection.getInputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                while ((n = in.read(bytes)) != -1) {
                    baos.write(bytes, 0, n);
                }
                bytes = baos.toByteArray();
                clazz = this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (Exception e) {
                exception = e;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (clazz != null) {
                return clazz;
            }
            ++i;
        }
        throw new ClassNotFoundException(name, exception);
    }

    public static void main(String[] args) throws Exception {
        Method method;
        String codeBase = args[0];
        String mainClass = args[1];
        String[] newArgs = new String[args.length - 2];
        System.arraycopy(args, 2, newArgs, 0, newArgs.length);
        try {
            Class<?> clazz = new NetworkURLClassLoader(codeBase).loadClass(mainClass);
            method = clazz.getDeclaredMethod("main", String[].class);
            method.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return;
        }
        method.invoke(null, new Object[]{newArgs});
    }
}

