/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.NSSystemProperty;
import chrriis.dj.nativeswing.common.ObjectRegistry;
import chrriis.dj.nativeswing.common.Utils;
import chrriis.dj.nativeswing.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.EventDispatchUtils;
import chrriis.dj.nativeswing.swtimpl.LocalMessage;
import chrriis.dj.nativeswing.swtimpl.NSPanelComponent;
import chrriis.dj.nativeswing.swtimpl.components.HTMLEditorDirtyStateEvent;
import chrriis.dj.nativeswing.swtimpl.components.HTMLEditorListener;
import chrriis.dj.nativeswing.swtimpl.components.JHTMLEditorCKeditor;
import chrriis.dj.nativeswing.swtimpl.components.JHTMLEditorFCKeditor;
import chrriis.dj.nativeswing.swtimpl.components.JHTMLEditorTinyMCE;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserCommandEvent;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JHTMLEditor
extends NSPanelComponent {
    private JWebBrowser webBrowser;
    private int instanceID;
    private JHTMLEditorImplementation implementation;
    private boolean isDirty;
    private static /* synthetic */ int[] $SWITCH_TABLE$chrriis$dj$nativeswing$swtimpl$components$JHTMLEditor$HTMLEditorImplementation;

    JHTMLEditorImplementation getImplementation() {
        return this.implementation;
    }

    /*
     * Unable to fully structure code
     */
    public JHTMLEditor(HTMLEditorImplementation editorImplementation, NSOption ... options) {
        super();
        if (editorImplementation == null) {
            throw new NullPointerException("The editor implementation cannot be null!");
        }
        optionMap = NSOption.createOptionMap((NSOption[])options);
        this.webBrowser = new JWebBrowser(options);
        this.initialize(this.webBrowser.getNativeComponent());
        switch (JHTMLEditor.$SWITCH_TABLE$chrriis$dj$nativeswing$swtimpl$components$JHTMLEditor$HTMLEditorImplementation()[editorImplementation.ordinal()]) {
            case 1: {
                try {
                    this.implementation = new JHTMLEditorFCKeditor(this, optionMap);
                    break;
                }
                catch (RuntimeException e) {
                    if (editorImplementation == null) ** GOTO lbl15
                    throw e;
                }
            }
lbl15:
            // 2 sources

            case 2: {
                try {
                    this.implementation = new JHTMLEditorCKeditor(this, optionMap);
                    break;
                }
                catch (RuntimeException e) {
                    if (editorImplementation == null) ** GOTO lbl22
                    throw e;
                }
            }
lbl22:
            // 2 sources

            case 3: {
                try {
                    this.implementation = new JHTMLEditorTinyMCE(this, optionMap);
                    break;
                }
                catch (RuntimeException e) {
                    if (editorImplementation == null) ** GOTO lbl29
                    throw e;
                }
            }
lbl29:
            // 2 sources

            default: {
                throw new IllegalStateException("A suitable HTML editor (FCKeditor, CKeditor, TinyMCE) distribution could not be found on the classpath!");
            }
        }
        this.webBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            public void commandReceived(WebBrowserCommandEvent e) {
                String command = e.getCommand();
                if ("[Chrriis]JH_setLoaded".equals(command)) {
                    Object[] listeners = JHTMLEditor.this.listenerList.getListenerList();
                    int i = listeners.length - 2;
                    while (i >= 0) {
                        if (listeners[i] == InitializationListener.class) {
                            ((InitializationListener)listeners[i + 1]).objectInitialized();
                        }
                        i -= 2;
                    }
                } else if ("[Chrriis]JH_setDirty".equals(command)) {
                    JHTMLEditor.this.setDirty(true);
                }
            }
        });
        this.webBrowser.setBarsVisible(false);
        this.add((Component)this.webBrowser, "Center");
        this.instanceID = ObjectRegistry.getInstance().add((Object)this);
        result = new AtomicBoolean();
        initializationListener = new InitializationListener(){

            public void objectInitialized() {
                JHTMLEditor.this.removeInitializationListener(this);
                result.set(true);
            }
        };
        this.addInitializationListener(initializationListener);
        this.webBrowser.navigate(WebServer.getDefaultWebServer().getDynamicContentURL(JHTMLEditor.class.getName(), String.valueOf(this.instanceID), "index.html"));
        this.webBrowser.getNativeComponent().runSync(new LocalMessage(){

            public Object run(Object[] args) {
                InitializationListener initializationListener = (InitializationListener)args[0];
                final AtomicBoolean result = (AtomicBoolean)args[1];
                EventDispatchUtils.sleepWithEventDispatch(new EventDispatchUtils.Condition(){

                    public boolean getValue() {
                        return result.get();
                    }
                }, 4000);
                JHTMLEditor.this.removeInitializationListener(initializationListener);
                return null;
            }
        }, new Object[]{initializationListener, result});
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    protected static WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest httpRequest) {
        String resourcePath = httpRequest.getResourcePath();
        int index = resourcePath.indexOf(47);
        int instanceID = Integer.parseInt(resourcePath.substring(0, index));
        JHTMLEditor htmlEditor = (JHTMLEditor)ObjectRegistry.getInstance().get(instanceID);
        if (htmlEditor == null) {
            return null;
        }
        String resourcePath_ = resourcePath.substring(index + 1);
        if (resourcePath_.startsWith("/")) {
            resourcePath_ = resourcePath_.substring(1);
        }
        return htmlEditor.getWebServerContent(httpRequest, resourcePath_, instanceID);
    }

    protected WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest httpRequest, String resourcePath, int instanceID) {
        return this.implementation.getWebServerContent(httpRequest, resourcePath, instanceID);
    }

    public String getHTMLContent() {
        return JHTMLEditor.convertLinksToLocal(this.implementation.getHTMLContent());
    }

    public void setHTMLContent(String html) {
        html = JHTMLEditor.convertLinksFromLocal(html.replaceAll("[\r\n]", " "));
        this.implementation.setHTMLContent(html);
        this.setDirty(false);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private void setDirty(boolean isDirty) {
        if (this.isDirty == isDirty) {
            return;
        }
        this.isDirty = isDirty;
        Object[] listeners = this.listenerList.getListenerList();
        HTMLEditorDirtyStateEvent ev = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == HTMLEditorListener.class) {
                if (ev == null) {
                    ev = new HTMLEditorDirtyStateEvent(this, isDirty);
                }
                ((HTMLEditorListener)listeners[i + 1]).notifyDirtyStateChanged(ev);
            }
            i -= 2;
        }
    }

    public void clearDirtyState() {
        this.implementation.clearDirtyIndicator();
        this.setDirty(false);
    }

    static String convertLinksToLocal(String html) {
        String resource;
        String codeBase;
        Matcher m;
        if (html == null) {
            return html;
        }
        Pattern p = Pattern.compile("=\\s*\"(" + WebServer.getDefaultWebServer().getURLPrefix() + "/resource/)([^/]+)/([^\"]+)\"\\s");
        while ((m = p.matcher(html)).find()) {
            codeBase = html.substring(m.start(2), m.end(2));
            resource = html.substring(m.start(3), m.end(3));
            try {
                resource = new File(Utils.decodeURL((String)Utils.decodeURL((String)codeBase)), resource).toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            html = String.valueOf(html.substring(0, m.start(1))) + resource + html.substring(m.end(3));
        }
        p = Pattern.compile("=\\s*\"(" + WebServer.getDefaultWebServer().getURLPrefix() + "/location/)([^/]+)/([^\"]+)\"\\s");
        while ((m = p.matcher(html)).find()) {
            codeBase = html.substring(m.start(2), m.end(2));
            resource = html.substring(m.start(3), m.end(3));
            try {
                resource = new File(Utils.decodeBase64((String)codeBase), Utils.decodeURL((String)resource)).toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            html = String.valueOf(html.substring(0, m.start(1))) + resource + html.substring(m.end(3));
        }
        return html;
    }

    static String convertLinksFromLocal(String html) {
        Matcher m;
        if (html == null) {
            return html;
        }
        Pattern p = Pattern.compile("=\\s*\"(file:/{1,3})([^\"]+)\"\\s");
        while ((m = p.matcher(html)).find()) {
            File resourceFile;
            String resource = html.substring(m.start(2), m.end(2));
            if (Boolean.parseBoolean(NSSystemProperty.WEBSERVER_ACTIVATEOLDRESOURCEMETHOD.get())) {
                resourceFile = new File(resource);
                resource = WebServer.getDefaultWebServer().getResourcePathURL(Utils.encodeURL((String)resourceFile.getParent()), resourceFile.getName());
            } else {
                resourceFile = new File(Utils.decodeURL((String)resource));
                resource = WebServer.getDefaultWebServer().getResourcePathURL(resourceFile.getParent(), resourceFile.getName());
            }
            html = String.valueOf(html.substring(0, m.start(1))) + resource + html.substring(m.end(2));
        }
        return html;
    }

    public void addHTMLEditorListener(HTMLEditorListener listener) {
        this.listenerList.add(HTMLEditorListener.class, listener);
    }

    public void removeHTMLEditorListener(HTMLEditorListener listener) {
        this.listenerList.remove(HTMLEditorListener.class, listener);
    }

    public HTMLEditorListener[] getHTMLEditorListeners() {
        return (HTMLEditorListener[])this.listenerList.getListeners(HTMLEditorListener.class);
    }

    private void addInitializationListener(InitializationListener listener) {
        this.listenerList.add(InitializationListener.class, listener);
    }

    private void removeInitializationListener(InitializationListener listener) {
        this.listenerList.remove(InitializationListener.class, listener);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$chrriis$dj$nativeswing$swtimpl$components$JHTMLEditor$HTMLEditorImplementation() {
        if ($SWITCH_TABLE$chrriis$dj$nativeswing$swtimpl$components$JHTMLEditor$HTMLEditorImplementation != null) {
            return $SWITCH_TABLE$chrriis$dj$nativeswing$swtimpl$components$JHTMLEditor$HTMLEditorImplementation;
        }
        int[] nArray = new int[HTMLEditorImplementation.values().length];
        try {
            nArray[HTMLEditorImplementation.CKEditor.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTMLEditorImplementation.FCKEditor.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTMLEditorImplementation.TinyMCE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$chrriis$dj$nativeswing$swtimpl$components$JHTMLEditor$HTMLEditorImplementation = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CKEditorOptions {
        static final String SET_OPTIONS_OPTION_KEY = "CKEditor Options";

        private CKEditorOptions() {
        }

        public static NSOption setOptions(Map<String, String> optionMap) {
            final HashMap<String, String> optionMap_ = new HashMap<String, String>(optionMap);
            return new NSOption(SET_OPTIONS_OPTION_KEY){

                public Object getOptionValue() {
                    return optionMap_;
                }
            };
        }
    }

    public static class FCKEditorOptions {
        static final String SET_CUSTOM_JAVASCRIPT_CONFIGURATION_OPTION_KEY = "FCKEditor Custom Configuration Script";

        private FCKEditorOptions() {
        }

        public static NSOption setCustomJavascriptConfiguration(final String javascriptConfiguration) {
            return new NSOption(SET_CUSTOM_JAVASCRIPT_CONFIGURATION_OPTION_KEY){

                public Object getOptionValue() {
                    return javascriptConfiguration;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HTMLEditorImplementation {
        FCKEditor,
        CKEditor,
        TinyMCE;

    }

    private static interface InitializationListener
    extends EventListener {
        public void objectInitialized();
    }

    static interface JHTMLEditorImplementation {
        public WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest var1, String var2, int var3);

        public String getHTMLContent();

        public void setHTMLContent(String var1);

        public void setDirtyTrackingActive(boolean var1);

        public void clearDirtyIndicator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TinyMCEOptions {
        static final String SET_CUSTOM_HTML_HEADERS_OPTION_KEY = "TinyMCE Custom HTML Headers";
        static final String SET_OPTIONS_OPTION_KEY = "TinyMCE Options";

        private TinyMCEOptions() {
        }

        public static NSOption setCustomHTMLHeaders(final String customHTMLHeaders) {
            return new NSOption(SET_CUSTOM_HTML_HEADERS_OPTION_KEY){

                public Object getOptionValue() {
                    return customHTMLHeaders;
                }
            };
        }

        public static NSOption setOptions(Map<String, String> optionMap) {
            final HashMap<String, String> optionMap_ = new HashMap<String, String>(optionMap);
            return new NSOption(SET_OPTIONS_OPTION_KEY){

                public Object getOptionValue() {
                    return optionMap_;
                }
            };
        }
    }
}

