/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.dj.nativeswing.common.Utils;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowserWindow;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;

public class WebBrowserWindowFactory {
    public static JWebBrowserWindow create(JWebBrowser webBrowser) {
        return WebBrowserWindowFactory.create(null, webBrowser);
    }

    public static JWebBrowserWindow create(Window parentWindow, JWebBrowser webBrowser) {
        final WebBrowserWindowStrategy webBrowserWindowStrategy = new WebBrowserWindowStrategy(webBrowser);
        JWebBrowserWindow webBrowserWindow = WebBrowserWindowFactory.createWindow(webBrowserWindowStrategy, parentWindow, parentWindow != null);
        webBrowser.getWebBrowserDecorator().configureForWebBrowserWindow(webBrowserWindow);
        ((RootPaneContainer)((Object)webBrowserWindow)).getContentPane().add((Component)webBrowser, "Center");
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        size.width = size.width * 80 / 100;
        size.height = size.height * 80 / 100;
        Window window = (Window)((Object)webBrowserWindow);
        window.setSize(size);
        window.setLocationByPlatform(true);
        window.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                webBrowserWindowStrategy.getWebBrowser().requestFocus();
            }
        });
        return webBrowserWindow;
    }

    private static JWebBrowserWindow createWindow(WebBrowserWindowStrategy webBrowserWindowStrategy, Window parentWindow, boolean isDialog) {
        Window window = isDialog ? (parentWindow instanceof Frame ? new WebBrowserDialog(webBrowserWindowStrategy, (Frame)parentWindow) : new WebBrowserDialog(webBrowserWindowStrategy, (Dialog)parentWindow)) : new WebBrowserFrame(webBrowserWindowStrategy);
        return window;
    }

    private static class WebBrowserDialog
    extends JDialog
    implements JWebBrowserWindow {
        private WebBrowserWindowStrategy webBrowserWindowStrategy;

        public WebBrowserDialog(WebBrowserWindowStrategy webBrowserWindowStrategy, Frame parentWindow) {
            super(parentWindow);
            this.webBrowserWindowStrategy = webBrowserWindowStrategy;
            this.setDefaultCloseOperation(2);
        }

        public WebBrowserDialog(WebBrowserWindowStrategy webBrowserWindowStrategy, Dialog parentWindow) {
            super(parentWindow);
            this.webBrowserWindowStrategy = webBrowserWindowStrategy;
            this.setDefaultCloseOperation(2);
        }

        public void show() {
            boolean isLocationByPlatform = this.isLocationByPlatform();
            super.show();
            if (isLocationByPlatform) {
                WebBrowserWindowStrategy.adjustInScreen(this);
            }
        }

        public void setIconImage(Image image) {
            if (Utils.IS_JAVA_6_OR_GREATER) {
                super.setIconImage(image);
            }
        }

        public JWebBrowser getWebBrowser() {
            return this.webBrowserWindowStrategy.getWebBrowser();
        }

        public void setBarsVisible(boolean areBarsVisible) {
            this.webBrowserWindowStrategy.setBarsVisible(areBarsVisible);
        }

        public void setStatusBarVisible(boolean isStatusBarVisible) {
            this.webBrowserWindowStrategy.setStatusBarVisible(isStatusBarVisible);
        }

        public boolean isStatusBarVisisble() {
            return this.webBrowserWindowStrategy.isStatusBarVisisble();
        }

        public void setMenuBarVisible(boolean isMenuBarVisible) {
            this.webBrowserWindowStrategy.setMenuBarVisible(isMenuBarVisible);
        }

        public boolean isMenuBarVisisble() {
            return this.webBrowserWindowStrategy.isMenuBarVisisble();
        }

        public void setButtonBarVisible(boolean isButtonBarVisible) {
            this.webBrowserWindowStrategy.setButtonBarVisible(isButtonBarVisible);
        }

        public boolean isButtonBarVisisble() {
            return this.webBrowserWindowStrategy.isButtonBarVisisble();
        }

        public void setLocationBarVisible(boolean isLocationBarVisible) {
            this.webBrowserWindowStrategy.setLocationBarVisible(isLocationBarVisible);
        }

        public boolean isLocationBarVisisble() {
            return this.webBrowserWindowStrategy.isLocationBarVisisble();
        }
    }

    private static class WebBrowserFrame
    extends JFrame
    implements JWebBrowserWindow {
        private WebBrowserWindowStrategy webBrowserWindowStrategy;

        public WebBrowserFrame(WebBrowserWindowStrategy webBrowserWindowStrategy) {
            this.webBrowserWindowStrategy = webBrowserWindowStrategy;
            this.setDefaultCloseOperation(2);
        }

        public void show() {
            boolean isLocationByPlatform = this.isLocationByPlatform();
            super.show();
            if (isLocationByPlatform) {
                WebBrowserWindowStrategy.adjustInScreen(this);
            }
        }

        public JWebBrowser getWebBrowser() {
            return this.webBrowserWindowStrategy.getWebBrowser();
        }

        public void setBarsVisible(boolean areBarsVisible) {
            this.webBrowserWindowStrategy.setBarsVisible(areBarsVisible);
        }

        public void setStatusBarVisible(boolean isStatusBarVisible) {
            this.webBrowserWindowStrategy.setStatusBarVisible(isStatusBarVisible);
        }

        public boolean isStatusBarVisisble() {
            return this.webBrowserWindowStrategy.isStatusBarVisisble();
        }

        public void setMenuBarVisible(boolean isMenuBarVisible) {
            this.webBrowserWindowStrategy.setMenuBarVisible(isMenuBarVisible);
        }

        public boolean isMenuBarVisisble() {
            return this.webBrowserWindowStrategy.isMenuBarVisisble();
        }

        public void setButtonBarVisible(boolean isButtonBarVisible) {
            this.webBrowserWindowStrategy.setButtonBarVisible(isButtonBarVisible);
        }

        public boolean isButtonBarVisisble() {
            return this.webBrowserWindowStrategy.isButtonBarVisisble();
        }

        public void setLocationBarVisible(boolean isLocationBarVisible) {
            this.webBrowserWindowStrategy.setLocationBarVisible(isLocationBarVisible);
        }

        public boolean isLocationBarVisisble() {
            return this.webBrowserWindowStrategy.isLocationBarVisisble();
        }
    }

    private static class WebBrowserWindowStrategy {
        private JWebBrowser webBrowser;

        public WebBrowserWindowStrategy(JWebBrowser webBrowser) {
            this.webBrowser = webBrowser;
        }

        public JWebBrowser getWebBrowser() {
            return this.webBrowser;
        }

        public void setBarsVisible(boolean areBarsVisible) {
            this.webBrowser.setBarsVisible(areBarsVisible);
        }

        public void setStatusBarVisible(boolean isStatusBarVisible) {
            this.webBrowser.setStatusBarVisible(isStatusBarVisible);
        }

        public boolean isStatusBarVisisble() {
            return this.webBrowser.isStatusBarVisible();
        }

        public void setMenuBarVisible(boolean isMenuBarVisible) {
            this.webBrowser.setMenuBarVisible(isMenuBarVisible);
        }

        public boolean isMenuBarVisisble() {
            return this.webBrowser.isMenuBarVisible();
        }

        public void setButtonBarVisible(boolean isButtonBarVisible) {
            this.webBrowser.setButtonBarVisible(isButtonBarVisible);
        }

        public boolean isButtonBarVisisble() {
            return this.webBrowser.isButtonBarVisible();
        }

        public void setLocationBarVisible(boolean isLocationBarVisible) {
            this.webBrowser.setLocationBarVisible(isLocationBarVisible);
        }

        public boolean isLocationBarVisisble() {
            return this.webBrowser.isLocationBarVisible();
        }

        private static void adjustInScreen(Window window) {
            GraphicsConfiguration gc = window.getGraphicsConfiguration();
            Rectangle gcBounds = gc.getBounds();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            gcBounds.x += screenInsets.left;
            gcBounds.width -= screenInsets.left + screenInsets.right;
            gcBounds.y += screenInsets.top;
            gcBounds.height -= screenInsets.top + screenInsets.bottom;
            Rectangle bounds = window.getBounds();
            if (gcBounds.x + gcBounds.width < bounds.x + bounds.width) {
                bounds.x = gcBounds.x + gcBounds.width - bounds.width;
            }
            if (bounds.x < gcBounds.x) {
                bounds.x = gcBounds.x;
            }
            if (gcBounds.y + gcBounds.height < bounds.y + bounds.height) {
                bounds.y = gcBounds.y + gcBounds.height - bounds.height;
            }
            if (bounds.y < gcBounds.y) {
                bounds.y = gcBounds.y;
            }
            if (!window.getBounds().equals(bounds)) {
                window.setBounds(bounds);
            }
        }
    }
}

