/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.netbeans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.openide.LifecycleManager;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModuleHandler {
    private boolean isRestart = false;
    private OperationContainer<OperationSupport> oc;
    private OperationSupport.Restarter restarter;
    private final boolean isDirectMode;

    public ModuleHandler() {
        this(false);
    }

    public ModuleHandler(boolean isDirectMode) {
        this.isDirectMode = isDirectMode;
    }

    public List<String> getModules(String startFilter, boolean includeDisabled) {
        ArrayList<String> activatedModules = new ArrayList<String>();
        Collection lookupAll = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (ModuleInfo moduleInfo : lookupAll) {
            if (!includeDisabled && !moduleInfo.isEnabled() || startFilter != null && !moduleInfo.getCodeNameBase().startsWith(startFilter)) continue;
            activatedModules.add(moduleInfo.getCodeNameBase());
        }
        Collections.sort(activatedModules);
        return activatedModules;
    }

    public void doRestart(boolean isForced) {
        if (isForced || this.isRestart) {
            if (this.oc != null && this.restarter != null) {
                try {
                    ((OperationSupport)this.oc.getSupport()).doRestart(this.restarter, null);
                }
                catch (OperationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                LifecycleManager.getDefault().markForRestart();
                LifecycleManager.getDefault().exit();
            }
        }
    }

    public boolean setModulesState(Set<String> codeNames, boolean isEnabled) {
        boolean restartFlag = isEnabled ? this.setModulesEnabled(codeNames) : this.setModulesDisabled(codeNames);
        this.isRestart = this.isRestart || restartFlag;
        return this.isRestart;
    }

    private boolean setModulesDisabled(Set<String> codeNames) {
        HashSet<UpdateElement> toDisable = new HashSet<UpdateElement>();
        List allUpdateUnits = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        for (UpdateUnit unit : allUpdateUnits) {
            UpdateElement el;
            if (unit.getInstalled() == null || !(el = unit.getInstalled()).isEnabled() || !codeNames.contains(el.getCodeName())) continue;
            toDisable.add(el);
        }
        if (!toDisable.isEmpty()) {
            this.oc = this.isDirectMode ? OperationContainer.createForDirectDisable() : OperationContainer.createForDisable();
            for (UpdateElement module : toDisable) {
                OperationContainer.OperationInfo operationInfo;
                if (!this.oc.canBeAdded(module.getUpdateUnit(), module) || (operationInfo = this.oc.add(module)) == null) continue;
                Set requiredElements = operationInfo.getRequiredElements();
                this.oc.add((Collection)requiredElements);
            }
            try {
                OperationSupport support = (OperationSupport)this.oc.getSupport();
                if (support != null) {
                    this.restarter = support.doOperation(null);
                }
            }
            catch (OperationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.restarter != null;
    }

    private boolean setModulesEnabled(Set<String> codeNames) {
        HashSet<UpdateElement> toEnable = new HashSet<UpdateElement>();
        List allUpdateUnits = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        for (UpdateUnit unit : allUpdateUnits) {
            UpdateElement el;
            if (unit.getInstalled() == null || (el = unit.getInstalled()).isEnabled() || !codeNames.contains(el.getCodeName())) continue;
            toEnable.add(el);
        }
        if (!toEnable.isEmpty()) {
            this.oc = OperationContainer.createForEnable();
            for (UpdateElement module : toEnable) {
                OperationContainer.OperationInfo operationInfo;
                if (!this.oc.canBeAdded(module.getUpdateUnit(), module) || (operationInfo = this.oc.add(module)) == null) continue;
                Set requiredElements = operationInfo.getRequiredElements();
                this.oc.add((Collection)requiredElements);
            }
            try {
                OperationSupport support = (OperationSupport)this.oc.getSupport();
                if (support != null) {
                    this.restarter = support.doOperation(null);
                }
                return true;
            }
            catch (OperationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }
}

