/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile;

import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import kd.bos.cache.tempfile.TempFileJedisUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.apache.commons.lang.StringUtils;
import redis.clients.jedis.util.SafeEncoder;

public class MyInputStream
extends InputStream {
    protected byte[] buf;
    protected int totalSize;
    protected int pos;
    protected int readedSize = 0;
    protected Queue<String> mapKeyQueue;
    protected String key;

    public MyInputStream(String key, Queue<String> mapKeyQueue, int totalSize) {
        this.key = key;
        this.mapKeyQueue = mapKeyQueue;
        this.totalSize = totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetBufAndPos() {
        block5: {
            TempFileJedisUtil.JedisInfo jedisInfo = TempFileJedisUtil.getJedis();
            try {
                String redisKey = this.mapKeyQueue.poll();
                if (StringUtils.isNotEmpty((String)redisKey)) {
                    byte[] mkey = SafeEncoder.encode((String)redisKey);
                    byte[] values = jedisInfo.jedis.hget(SafeEncoder.encode((String)this.key), mkey);
                    if (values != null) {
                        this.buf = values;
                        this.pos = 0;
                        break block5;
                    }
                    throw new KDException(BosErrorCode.redisRead, new Object[]{"get key:" + this.key + "/" + redisKey + " value is null!"});
                }
                throw new KDException(BosErrorCode.redisRead, new Object[]{"thre redisKey is null!"});
            }
            finally {
                TempFileJedisUtil.release(jedisInfo.jedis, false);
            }
        }
    }

    @Override
    public synchronized int read() {
        if (this.readedSize < this.totalSize) {
            if (this.buf == null || this.pos >= this.buf.length) {
                this.resetBufAndPos();
            }
            ++this.readedSize;
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        int readLen;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readedSize >= this.totalSize) {
            return -1;
        }
        int avail = this.totalSize - this.readedSize;
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        for (int needReadLen = len; needReadLen > 0; needReadLen -= readLen) {
            int availBufLen;
            if (this.buf == null || this.pos >= this.buf.length) {
                this.resetBufAndPos();
            }
            readLen = (availBufLen = this.buf.length - this.pos) < needReadLen ? availBufLen : needReadLen;
            System.arraycopy(this.buf, this.pos, b, off, readLen);
            this.pos += readLen;
            this.readedSize += readLen;
            off += readLen;
        }
        return len;
    }

    @Override
    public synchronized int available() {
        return this.totalSize - this.readedSize;
    }

    @Override
    public synchronized long skip(long n) {
        int needSkipLen;
        int skipLen;
        int avail = this.totalSize - this.readedSize;
        if (n > (long)avail) {
            n = avail;
        }
        if (n <= 0L) {
            return 0L;
        }
        for (needSkipLen = (int)n; needSkipLen > 0; needSkipLen -= skipLen) {
            int availSkipBufLen;
            if (this.buf == null || this.pos >= this.buf.length) {
                this.resetBufAndPos();
            }
            skipLen = (availSkipBufLen = this.buf.length - this.pos) < needSkipLen ? availSkipBufLen : needSkipLen;
            this.pos += skipLen;
            this.readedSize += skipLen;
        }
        return needSkipLen;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

