/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile;

import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.tempfile.RedisTempFileCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;

public class TempFileJedisUtil {
    private static final Log logger = LogFactory.getLog(RedisTempFileCache.class);
    private static final String CONFIGKEY = "tempfile.redis";

    protected static void release(JedisClient jedis, boolean isBroken) {
        if (jedis != null) {
            jedis.close();
        }
    }

    protected static JedisInfo getJedis() {
        return TempFileJedisUtil.getJedis(CONFIGKEY);
    }

    protected static JedisInfo getJedis(String configKey) {
        String url = null;
        url = System.getProperty(configKey);
        if (url == null) {
            configKey = CacheConfigKeys.getSessionlessConfigKey((String)"tempfile");
            url = System.getProperty(configKey);
        }
        if (url == null) {
            logger.warn("TempFile cache not found for (configKey=" + configKey + "), use global sessionless cache.");
            configKey = CacheConfigKeys.getSessionlessConfigKey(null);
            url = System.getProperty(configKey);
        }
        if (url != null) {
            String info = "Load TempFile cache for (configKey=" + configKey + ") ";
            logger.info(info);
        }
        JedisInfo jedisInfo = new JedisInfo();
        jedisInfo.jedis = RedisFactory.getJedisClient((String)url);
        jedisInfo.configKey = configKey;
        return jedisInfo;
    }

    static class JedisInfo {
        protected JedisClient jedis;
        protected String configKey;

        JedisInfo() {
        }
    }
}

